/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.rcsb.cif.CifBuilder;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.FloatColumnBuilder;
import org.rcsb.cif.model.IntColumnBuilder;
import org.rcsb.cif.model.StrColumnBuilder;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.schema.SchemaProvider;
import org.rcsb.cif.schema.StandardSchemata;
import org.rcsb.cif.schema.mm.AtomSite;
import org.rcsb.cif.schema.mm.MaQaMetricLocal;
import org.rcsb.cif.schema.mm.MmCifBlock;
import org.rcsb.cif.schema.mm.MmCifBlockBuilder;
import org.rcsb.cif.schema.mm.MmCifCategoryBuilder;
import org.rcsb.cif.schema.mm.MmCifFile;
import org.rcsb.cif.schema.mm.MmCifFileBuilder;
import org.rcsb.cif.schema.mm.PdbxStructAssemblyGen;
import org.rcsb.cif.schema.mm.PdbxStructOperList;
import org.rcsb.strucmotif.config.ResidueQualityStrategy;
import org.rcsb.strucmotif.config.StrucmotifConfig;
import org.rcsb.strucmotif.domain.structure.LabelAtomId;
import org.rcsb.strucmotif.domain.structure.LabelSelection;
import org.rcsb.strucmotif.domain.structure.PolymerType;
import org.rcsb.strucmotif.domain.structure.ResidueType;
import org.rcsb.strucmotif.io.ResidueTypeResolver;
import org.rcsb.strucmotif.io.StructureWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StructureWriterImpl
implements StructureWriter {
    private static final Logger logger = LoggerFactory.getLogger(StructureWriterImpl.class);
    private final CifOptions options;
    private final ResidueQualityStrategy residueQualityStrategy;
    private final double residueQualityCutoff;
    private final ResidueTypeResolver residueTypeResolver;

    public StructureWriterImpl(ResidueTypeResolver residueTypeResolver, StrucmotifConfig strucmotifConfig) {
        int precision = strucmotifConfig.getRenumberedCoordinatePrecision();
        boolean gzipped = strucmotifConfig.isRenumberedGzip();
        this.options = CifOptions.builder().encodingStrategyHint("atom_site", "Cartn_x", "delta", precision).encodingStrategyHint("atom_site", "Cartn_y", "delta", precision).encodingStrategyHint("atom_site", "Cartn_z", "delta", precision).gzip(gzipped).build();
        this.residueQualityStrategy = strucmotifConfig.getResidueQualityStrategy();
        this.residueQualityCutoff = strucmotifConfig.getResidueQualityCutoff();
        if (this.residueQualityStrategy == ResidueQualityStrategy.NONE) {
            logger.info("All valid residues be indexed");
        } else {
            logger.info("Residues will be filtered by {} with a cutoff of {}", (Object)this.residueQualityStrategy, (Object)this.residueQualityCutoff);
        }
        this.residueTypeResolver = residueTypeResolver;
    }

    @Override
    public void write(MmCifFile source, Path destination) {
        MmCifBlock block = (MmCifBlock)source.getFirstBlock();
        PdbxStructAssemblyGen pdbxStructAssemblyGen = block.getPdbxStructAssemblyGen();
        PdbxStructOperList pdbxStructOperList = block.getPdbxStructOperList();
        AtomSite atomSite = block.getAtomSite();
        String pdbId = block.getBlockHeader().toUpperCase();
        MmCifBlockBuilder outputBuilder = ((MmCifFileBuilder)CifBuilder.enterFile((SchemaProvider)StandardSchemata.MMCIF)).enterBlock(pdbId.toUpperCase());
        if (pdbxStructAssemblyGen.isDefined()) {
            outputBuilder.addCategory((Category)pdbxStructAssemblyGen);
        }
        if (pdbxStructOperList.isDefined()) {
            outputBuilder.addCategory((Category)pdbxStructOperList);
        }
        List<LabelSelection> validResidues = this.determineValidResidues(block);
        MmCifCategoryBuilder.AtomSiteBuilder atomSiteBuilder = outputBuilder.enterAtomSite();
        StrColumnBuilder labelAtomId = atomSiteBuilder.enterLabelAtomId();
        StrColumnBuilder labelCompId = atomSiteBuilder.enterLabelCompId();
        StrColumnBuilder labelAsymId = atomSiteBuilder.enterLabelAsymId();
        IntColumnBuilder labelSeqId = atomSiteBuilder.enterLabelSeqId();
        FloatColumnBuilder cartnX = atomSiteBuilder.enterCartnX();
        FloatColumnBuilder cartnY = atomSiteBuilder.enterCartnY();
        FloatColumnBuilder cartnZ = atomSiteBuilder.enterCartnZ();
        String lastAcceptedLabelAsymId = "";
        int lastAcceptedLabelSeqId = Integer.MIN_VALUE;
        LabelAtomId lastAcceptedAtomLabelId = LabelAtomId.UNKNOWN_ATOM;
        EnumSet<LabelAtomId> currentlyAcceptedLabelAtomIds = EnumSet.noneOf(LabelAtomId.class);
        for (int row = 0; row < atomSite.getRowCount(); ++row) {
            ResidueType residueType;
            String element;
            if (atomSite.getPdbxPDBModelNum().isDefined() && atomSite.getPdbxPDBModelNum().get(row) != 1 || "H".equals(element = atomSite.getTypeSymbol().get(row)) || "D".equals(element) || "T".equals(element) || atomSite.getLabelSeqId().getValueKind(row) != ValueKind.PRESENT) continue;
            String currentLabelAsymId = atomSite.getLabelAsymId().get(row);
            int currentLabelSeqId = atomSite.getLabelSeqId().get(row);
            LabelAtomId currentLabelAtomId = LabelAtomId.ofLabelAtomId(atomSite.getLabelAtomId().get(row));
            String currentLabelAltId = atomSite.getLabelAltId().get(row);
            String currentLabelCompId = atomSite.getLabelCompId().get(row);
            if (currentLabelAtomId == LabelAtomId.UNKNOWN_ATOM || StructureWriterImpl.ambiguousAtom(residueType = this.residueTypeResolver.selectResidueType(currentLabelCompId), currentLabelAtomId) || !validResidues.contains(new LabelSelection(currentLabelAsymId, "1", currentLabelSeqId)) || !currentLabelAltId.isEmpty() && currentLabelAsymId.equals(lastAcceptedLabelAsymId) && currentLabelSeqId == lastAcceptedLabelSeqId && currentLabelAtomId.equals((Object)lastAcceptedAtomLabelId)) continue;
            if (currentLabelAsymId.equals(lastAcceptedLabelAsymId) && currentLabelSeqId == lastAcceptedLabelSeqId) {
                if (currentlyAcceptedLabelAtomIds.contains((Object)currentLabelAtomId)) {
                    continue;
                }
            } else {
                currentlyAcceptedLabelAtomIds.clear();
            }
            currentlyAcceptedLabelAtomIds.add(currentLabelAtomId);
            lastAcceptedAtomLabelId = currentLabelAtomId;
            lastAcceptedLabelSeqId = currentLabelSeqId;
            lastAcceptedLabelAsymId = currentLabelAsymId;
            labelAtomId.add(new String[]{currentLabelAtomId.getLabelAtomId()});
            labelCompId.add(new String[]{currentLabelCompId});
            labelAsymId.add(new String[]{currentLabelAsymId});
            labelSeqId.add(new int[]{currentLabelSeqId});
            cartnX.add(new double[]{atomSite.getCartnX().get(row)});
            cartnY.add(new double[]{atomSite.getCartnY().get(row)});
            cartnZ.add(new double[]{atomSite.getCartnZ().get(row)});
        }
        atomSiteBuilder.leaveCategory();
        MmCifFile outputFile = outputBuilder.leaveBlock().leaveFile();
        if (((MmCifBlock)outputFile.getBlocks().get(0)).getAtomSite().getRowCount() == 0) {
            return;
        }
        try {
            CifIO.writeBinary((CifFile)outputFile, (Path)destination, (CifOptions)this.options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<LabelSelection> determineValidResidues(MmCifBlock block) {
        atomSite = block.getAtomSite();
        residueTypes = new HashMap<LabelSelection, ResidueType>();
        presentAtoms = new HashMap<LabelSelection, Set>();
        block4: for (row = 0; row < atomSite.getRowCount(); ++row) {
            if (atomSite.getLabelSeqId().getValueKind(row) != ValueKind.PRESENT) continue;
            labelAsymId = atomSite.getLabelAsymId().get(row);
            labelSeqId = atomSite.getLabelSeqId().get(row);
            if (this.residueQualityStrategy == ResidueQualityStrategy.NONE) ** GOTO lbl-1000
            switch (1.$SwitchMap$org$rcsb$strucmotif$config$ResidueQualityStrategy[this.residueQualityStrategy.ordinal()]) {
                case 1: 
                case 2: {
                    if (atomSite.getBIsoOrEquiv().isDefined() && atomSite.getBIsoOrEquiv().getValueKind(row) == ValueKind.PRESENT && !this.residueQualityStrategy.test(atomSite.getBIsoOrEquiv().get(row), this.residueQualityCutoff)) continue block4;
                }
                case 3: 
                case 4: {
                    category = block.getMaQaMetricLocal();
                    if (category.isDefined() && !this.residueQualityStrategy.test(metricValue = this.findMetricValue(category, labelAsymId, labelSeqId), this.residueQualityCutoff)) continue block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    labelSelection = new LabelSelection(labelAsymId, "1", labelSeqId);
                    residueType = this.residueTypeResolver.selectResidueType(atomSite.getLabelCompId().get(row));
                    if (residueType == ResidueType.UNKNOWN_COMPONENT) continue block4;
                    residueTypes.put(labelSelection, residueType);
                    atoms = presentAtoms.computeIfAbsent(labelSelection, (Function<LabelSelection, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$determineValidResidues$0(org.rcsb.strucmotif.domain.structure.LabelSelection ), (Lorg/rcsb/strucmotif/domain/structure/LabelSelection;)Ljava/util/Set;)());
                    atoms.add(LabelAtomId.ofLabelAtomId(atomSite.getLabelAtomId().get(row)));
                }
            }
        }
        validResidues = new ArrayList<LabelSelection>();
        for (Map.Entry<K, V> entry : residueTypes.entrySet()) {
            labelSelection = (LabelSelection)entry.getKey();
            residueType = (ResidueType)entry.getValue();
            atoms = (Set)presentAtoms.get(labelSelection);
            if (residueType.getPolymerType() == PolymerType.AMINO_ACID) {
                if (residueType != ResidueType.GLYCINE) {
                    if (!atoms.contains((Object)LabelAtomId.CA) || !atoms.contains((Object)LabelAtomId.CB)) continue;
                    validResidues.add(labelSelection);
                    continue;
                }
                if (!atoms.contains((Object)LabelAtomId.N) || !atoms.contains((Object)LabelAtomId.CA) || !atoms.contains((Object)LabelAtomId.C)) continue;
                validResidues.add(labelSelection);
                continue;
            }
            if (!atoms.contains((Object)LabelAtomId.C4_PRIME) || !atoms.contains((Object)LabelAtomId.C1_PRIME)) continue;
            validResidues.add(labelSelection);
        }
        return validResidues;
    }

    private static boolean ambiguousAtom(ResidueType residueType, LabelAtomId labelAtomId) {
        switch (residueType) {
            case ARGININE: {
                return labelAtomId == LabelAtomId.NH1 || labelAtomId == LabelAtomId.NH2;
            }
            case ASPARTIC_ACID: {
                return labelAtomId == LabelAtomId.OD1 || labelAtomId == LabelAtomId.OD2;
            }
            case GLUTAMIC_ACID: {
                return labelAtomId == LabelAtomId.OE1 || labelAtomId == LabelAtomId.OE2;
            }
            case PHENYLALANINE: 
            case TYROSINE: {
                return labelAtomId == LabelAtomId.CD1 || labelAtomId == LabelAtomId.CD2 || labelAtomId == LabelAtomId.CE1 || labelAtomId == LabelAtomId.CE2;
            }
        }
        return false;
    }

    private double findMetricValue(MaQaMetricLocal category, String labelAsymId, int labelSeqId) {
        for (int i = 0; i < category.getRowCount(); ++i) {
            if (!category.getLabelAsymId().get(i).equals(labelAsymId) || category.getLabelSeqId().get(i) != labelSeqId) continue;
            return category.getMetricValue().get(i);
        }
        throw new NoSuchElementException("No in '" + category.getCategoryName() + "' for '" + labelAsymId + "-" + labelSeqId + "'");
    }

    private static /* synthetic */ Set lambda$determineValidResidues$0(LabelSelection e) {
        return EnumSet.noneOf(LabelAtomId.class);
    }
}

