/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.rcsb.strucmotif.domain.bucket.Bucket;
import org.rcsb.strucmotif.io.codec.BucketCodec;

public abstract class AbstractBucketCodec
implements BucketCodec {
    @Override
    public ByteArrayOutputStream encode(Bucket bucket) throws IOException {
        ArrayBucket arrays = AbstractBucketCodec.toArrays(bucket);
        return this.encode(arrays.getStructureIndices(), arrays.getPositionOffsets(), arrays.getPositionData(), arrays.getOperatorIndices(), arrays.getOperatorData());
    }

    private static ArrayBucket toArrays(Bucket bucket) {
        int structureCount = bucket.getStructureCount();
        int[] structureIndices = new int[structureCount];
        int[] positionOffsets = new int[structureCount];
        int[] positionData = new int[bucket.getResiduePairCount() * 2];
        ArrayList<Integer> operatorIndicesList = new ArrayList<Integer>();
        ArrayList<String> operatorDataList = new ArrayList<String>();
        int structurePointer = 0;
        int positionPointer = 0;
        while (bucket.hasNextStructure()) {
            bucket.moveStructure();
            structureIndices[structurePointer] = bucket.getStructureIndex();
            positionOffsets[structurePointer] = positionPointer;
            while (bucket.hasNextOccurrence()) {
                bucket.moveOccurrence();
                positionData[positionPointer] = bucket.getIndex1();
                positionData[positionPointer + 1] = bucket.getIndex2();
                String structOperId1 = bucket.getStructOperId1();
                String structOperId2 = bucket.getStructOperId2();
                if (!structOperId1.equals("1")) {
                    operatorIndicesList.add(positionPointer);
                    operatorDataList.add(structOperId1);
                }
                if (!structOperId2.equals("1")) {
                    operatorIndicesList.add(positionPointer + 1);
                    operatorDataList.add(structOperId2);
                }
                positionPointer += 2;
            }
            ++structurePointer;
        }
        int[] operatorIndices = operatorIndicesList.stream().mapToInt(Integer::intValue).toArray();
        String[] operatorData = (String[])operatorDataList.toArray(String[]::new);
        return new ArrayBucket(structureIndices, positionOffsets, positionData, operatorIndices, operatorData);
    }

    static class ArrayBucket {
        private final int[] structureIndices;
        private final int[] positionOffsets;
        private final int[] positionData;
        private final int[] operatorIndices;
        private final String[] operatorData;

        ArrayBucket(int[] structureIndices, int[] positionOffsets, int[] positionData, int[] operatorIndices, String[] operatorData) {
            this.structureIndices = structureIndices;
            this.positionOffsets = positionOffsets;
            this.positionData = positionData;
            this.operatorIndices = operatorIndices;
            this.operatorData = operatorData;
        }

        public int[] getStructureIndices() {
            return this.structureIndices;
        }

        public int[] getPositionOffsets() {
            return this.positionOffsets;
        }

        public int[] getPositionData() {
            return this.positionData;
        }

        public int[] getOperatorIndices() {
            return this.operatorIndices;
        }

        public String[] getOperatorData() {
            return this.operatorData;
        }
    }
}

