/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.InputMismatchException;
import org.rcsb.strucmotif.domain.bucket.InvertedIndexBucket;
import org.rcsb.strucmotif.io.codec.AbstractBucketCodec;

public class ColferCodec
extends AbstractBucketCodec {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public InvertedIndexBucket decode(InputStream inputStream) throws IOException {
        byte[] buf = inputStream.readAllBytes();
        return this.decodeInternal(buf);
    }

    private InvertedIndexBucket decodeInternal(byte[] buf) {
        byte b;
        int shift;
        int x;
        int ai;
        byte b2;
        int shift2;
        int length;
        byte header;
        int[] structureIndices = EMPTY_INT_ARRAY;
        int[] positionOffsets = EMPTY_INT_ARRAY;
        int[] positionData = EMPTY_INT_ARRAY;
        int[] operatorIndices = EMPTY_INT_ARRAY;
        String[] operatorData = EMPTY_STRING_ARRAY;
        int i = 0;
        if ((header = buf[i++]) == 0) {
            length = 0;
            shift2 = 0;
            while (true) {
                b2 = buf[i++];
                length |= (b2 & 0x7F) << shift2;
                if (shift2 == 28 || b2 >= 0) break;
                shift2 += 7;
            }
            structureIndices = new int[length];
            for (ai = 0; ai < length; ++ai) {
                x = 0;
                shift = 0;
                while (true) {
                    b = buf[i++];
                    x |= (b & 0x7F) << shift;
                    if (shift == 28 || b >= 0) break;
                    shift += 7;
                }
                structureIndices[ai] = x >> 1 ^ -(x & 1);
            }
            header = buf[i++];
        }
        if (header == 1) {
            length = 0;
            shift2 = 0;
            while (true) {
                b2 = buf[i++];
                length |= (b2 & 0x7F) << shift2;
                if (shift2 == 28 || b2 >= 0) break;
                shift2 += 7;
            }
            positionOffsets = new int[length];
            for (ai = 0; ai < length; ++ai) {
                x = 0;
                shift = 0;
                while (true) {
                    b = buf[i++];
                    x |= (b & 0x7F) << shift;
                    if (shift == 28 || b >= 0) break;
                    shift += 7;
                }
                positionOffsets[ai] = x >> 1 ^ -(x & 1);
            }
            header = buf[i++];
        }
        if (header == 2) {
            length = 0;
            shift2 = 0;
            while (true) {
                b2 = buf[i++];
                length |= (b2 & 0x7F) << shift2;
                if (shift2 == 28 || b2 >= 0) break;
                shift2 += 7;
            }
            positionData = new int[length];
            for (ai = 0; ai < length; ++ai) {
                x = 0;
                shift = 0;
                while (true) {
                    b = buf[i++];
                    x |= (b & 0x7F) << shift;
                    if (shift == 28 || b >= 0) break;
                    shift += 7;
                }
                positionData[ai] = x >> 1 ^ -(x & 1);
            }
            header = buf[i++];
        }
        if (header == 3) {
            length = 0;
            shift2 = 0;
            while (true) {
                b2 = buf[i++];
                length |= (b2 & 0x7F) << shift2;
                if (shift2 == 28 || b2 >= 0) break;
                shift2 += 7;
            }
            operatorIndices = new int[length];
            for (ai = 0; ai < length; ++ai) {
                x = 0;
                shift = 0;
                while (true) {
                    b = buf[i++];
                    x |= (b & 0x7F) << shift;
                    if (shift == 28 || b >= 0) break;
                    shift += 7;
                }
                operatorIndices[ai] = x >> 1 ^ -(x & 1);
            }
            header = buf[i++];
        }
        if (header == 4) {
            length = 0;
            shift2 = 0;
            while (true) {
                b2 = buf[i++];
                length |= (b2 & 0x7F) << shift2;
                if (shift2 == 28 || b2 >= 0) break;
                shift2 += 7;
            }
            operatorData = new String[length];
            for (ai = 0; ai < length; ++ai) {
                int size = 0;
                shift = 0;
                while (true) {
                    b = buf[i++];
                    size |= (b & 0x7F) << shift;
                    if (shift == 28 || b >= 0) break;
                    shift += 7;
                }
                int start = i;
                i += size;
                operatorData[ai] = new String(buf, start, size, StandardCharsets.US_ASCII);
            }
            header = buf[i++];
        }
        if (header != 127) {
            throw new InputMismatchException("colfer: unknown header at byte " + (i - 1));
        }
        return new InvertedIndexBucket(structureIndices, positionOffsets, positionData, operatorIndices, operatorData);
    }

    private void encodeInternal(ByteArrayOutputStream out, int[] structureIndices, int[] positionOffset, int[] positionData, int[] operatorIndices, String[] operatorData) throws IOException {
        if (structureIndices.length != 0) {
            out.write(0);
            this.writeIntArray(out, structureIndices);
        }
        if (positionOffset.length != 0) {
            out.write(1);
            this.writeIntArray(out, positionOffset);
        }
        if (positionData.length != 0) {
            out.write(2);
            this.writeIntArray(out, positionData);
        }
        if (operatorIndices.length != 0) {
            out.write(3);
            this.writeIntArray(out, operatorIndices);
        }
        if (operatorData.length != 0) {
            out.write(4);
            this.writeStringArray(out, operatorData);
        }
        out.write(127);
    }

    private void writeIntArray(OutputStream out, int[] data) throws IOException {
        int x;
        for (x = data.length; x > 127; x >>>= 7) {
            out.write(x | 0x80);
        }
        out.write(x);
        for (int v : data) {
            int x1 = v << 1 ^ v >> 31;
            while ((x1 & 0xFFFFFF80) != 0) {
                out.write(x1 | 0x80);
                x1 >>>= 7;
            }
            out.write(x1);
        }
    }

    private void writeStringArray(OutputStream out, String[] data) throws IOException {
        int x;
        for (x = data.length; x > 127; x >>>= 7) {
            out.write(x | 0x80);
        }
        out.write(x);
        for (int ai = 0; ai < data.length; ++ai) {
            int length;
            String s = data[ai];
            if (s == null) {
                data[ai] = s = "";
            }
            for (length = s.length(); length > 127; length >>>= 7) {
                out.write(length | 0x80);
            }
            out.write(length);
            int sLength = s.length();
            for (int sIndex = 0; sIndex < sLength; ++sIndex) {
                char c = s.charAt(sIndex);
                if (c >= '\u0080') {
                    throw new IllegalArgumentException("Non-ASCII characters aren't supported");
                }
                out.write(c);
            }
        }
    }

    @Override
    public ByteArrayOutputStream encode(int[] structureIndices, int[] positionOffsets, int[] positionData, int[] operatorIndices, String[] operatorData) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.encodeInternal(outputStream, structureIndices, positionOffsets, positionData, operatorIndices, operatorData);
        return outputStream;
    }
}

