/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io.codec;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.rcsb.strucmotif.domain.bucket.InvertedIndexBucket;
import org.rcsb.strucmotif.io.codec.AbstractBucketCodec;

public class JsonCodec
extends AbstractBucketCodec {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public InvertedIndexBucket decode(InputStream inputStream) throws IOException {
        AbstractBucketCodec.ArrayBucket arrayBucket = (AbstractBucketCodec.ArrayBucket)this.gson.fromJson((Reader)new InputStreamReader(inputStream), AbstractBucketCodec.ArrayBucket.class);
        return new InvertedIndexBucket(arrayBucket.getStructureIndices(), arrayBucket.getPositionOffsets(), arrayBucket.getPositionData(), arrayBucket.getOperatorIndices(), arrayBucket.getOperatorData());
    }

    @Override
    public ByteArrayOutputStream encode(int[] structureIndices, int[] positionOffsets, int[] positionData, int[] operatorIndices, String[] operatorData) throws IOException {
        AbstractBucketCodec.ArrayBucket arrayBucket = new AbstractBucketCodec.ArrayBucket(structureIndices, positionOffsets, positionData, operatorIndices, operatorData);
        byte[] bytes = this.gson.toJson((Object)arrayBucket).getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.writeBytes(bytes);
        return outputStream;
    }
}

