/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.io.codec;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.rcsb.strucmotif.domain.bucket.InvertedIndexBucket;
import org.rcsb.strucmotif.io.codec.AbstractBucketCodec;

public class MessagePackCodec
extends AbstractBucketCodec {
    @Override
    public InvertedIndexBucket decode(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        InvertedIndexBucket bucket = this.decodeInternal(dataInputStream);
        dataInputStream.close();
        return bucket;
    }

    private InvertedIndexBucket decodeInternal(DataInputStream inputStream) throws IOException {
        int[] structureIndices = this.decodeIntArray(inputStream);
        int[] positionOffsets = this.decodeIntArray(inputStream);
        int[] positionData = this.decodeIntArray(inputStream);
        int[] operatorIndices = this.decodeIntArray(inputStream);
        String[] operatorData = this.decodeStringArray(inputStream);
        return new InvertedIndexBucket(structureIndices, positionOffsets, positionData, operatorIndices, operatorData);
    }

    private int[] decodeIntArray(DataInputStream inputStream) throws IOException {
        int[] out = new int[this.readArrayLength(inputStream)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.readInt(inputStream);
        }
        return out;
    }

    private int readInt(DataInputStream inputStream) throws IOException {
        byte int8 = inputStream.readByte();
        int type = int8 & 0xFF;
        if ((type & 0x80) == 0) {
            return type;
        }
        if ((type & 0xE0) == 224) {
            return int8;
        }
        switch (type) {
            case 204: {
                return inputStream.readByte() & 0xFF;
            }
            case 205: {
                return inputStream.readShort() & 0xFFFF;
            }
            case 206: {
                return this.readUnsignedInt(inputStream);
            }
            case 208: {
                return inputStream.readByte();
            }
            case 209: {
                return inputStream.readShort();
            }
            case 210: {
                return inputStream.readInt();
            }
        }
        throw new IllegalArgumentException("Unknown MessagePack type 0x" + Integer.toHexString(type) + ", expected a int here!");
    }

    private String[] decodeStringArray(DataInputStream inputStream) throws IOException {
        String[] out = new String[this.readArrayLength(inputStream)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.readString(inputStream);
        }
        return out;
    }

    private String readString(DataInputStream inputStream) throws IOException {
        byte[] bytes = new byte[this.readStringLength(inputStream)];
        inputStream.readFully(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private int readStringLength(DataInputStream inputStream) throws IOException {
        byte int8 = inputStream.readByte();
        int type = int8 & 0xFF;
        if ((type & 0xE0) == 160) {
            return type & 0x1F;
        }
        switch (type) {
            case 217: {
                return inputStream.readByte() & 0xFF;
            }
            case 218: {
                return inputStream.readShort() & 0xFFFF;
            }
            case 219: {
                return this.readUnsignedInt(inputStream);
            }
        }
        throw new IllegalArgumentException("Unexpected MessagePack type 0x" + Integer.toHexString(type) + ", expected a StringArray here!");
    }

    private int readArrayLength(DataInputStream inputStream) throws IOException {
        byte int8 = inputStream.readByte();
        int type = int8 & 0xFF;
        if ((type & 0xF0) == 144) {
            return type & 0xF;
        }
        if (type == 220) {
            return inputStream.readShort() & 0xFFFF;
        }
        if (type == 221) {
            return this.readUnsignedInt(inputStream);
        }
        throw new IllegalArgumentException("Unexpected MessagePack type 0x" + Integer.toHexString(type) + ", expected array length here!");
    }

    private int readUnsignedInt(DataInputStream inputStream) throws IOException {
        return (int)((long)inputStream.readInt() & 0xFFFFFFFFL);
    }

    private void encodeIntArray(int[] value, DataOutputStream outputStream) throws IOException {
        this.writeArrayLength(value.length, outputStream);
        for (int v : value) {
            this.writeInt(v, outputStream);
        }
    }

    private void encodeStringArray(String[] value, DataOutputStream outputStream) throws IOException {
        this.writeArrayLength(value.length, outputStream);
        for (String v : value) {
            this.writeString(v, outputStream);
        }
    }

    private void writeArrayLength(int length, DataOutputStream outputStream) throws IOException {
        if (length < 16) {
            outputStream.writeByte(length | 0x90);
        } else if (length < 65536) {
            outputStream.writeByte(220);
            outputStream.writeShort(length);
        } else {
            outputStream.writeByte(221);
            outputStream.writeInt(length);
        }
    }

    private void writeInt(int value, DataOutputStream outputStream) throws IOException {
        if (value >= 0) {
            if (value < 128) {
                outputStream.writeByte(value);
            } else if (value < 256) {
                outputStream.writeByte(204);
                outputStream.writeByte(value);
            } else if (value < 65536) {
                outputStream.writeByte(205);
                outputStream.writeShort(value);
            } else {
                outputStream.writeByte(206);
                outputStream.writeInt(value);
            }
            return;
        }
        if (value >= -32) {
            outputStream.writeByte(value);
        } else if (value >= -128) {
            outputStream.writeByte(208);
            outputStream.writeByte(value);
        } else if (value >= Short.MIN_VALUE) {
            outputStream.writeByte(209);
            outputStream.writeShort(value);
        } else {
            outputStream.writeByte(210);
            outputStream.writeInt(value);
        }
    }

    private void writeString(String value, DataOutputStream outputStream) throws IOException {
        int length = value.length();
        if (length < 32) {
            outputStream.writeByte(length | 0xA0);
        } else if (length < 256) {
            outputStream.writeByte(217);
            outputStream.writeByte(length);
        } else if (length < 65536) {
            outputStream.writeByte(218);
            outputStream.writeShort(length);
        } else {
            outputStream.writeByte(219);
            outputStream.writeInt(length);
        }
        outputStream.write(value.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public ByteArrayOutputStream encode(int[] structureIndices, int[] positionOffsets, int[] positionData, int[] operatorIndices, String[] operatorData) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.encodeIntArray(structureIndices, dataOutputStream);
        this.encodeIntArray(positionOffsets, dataOutputStream);
        this.encodeIntArray(positionData, dataOutputStream);
        this.encodeIntArray(operatorIndices, dataOutputStream);
        this.encodeStringArray(operatorData, dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
        return byteArrayOutputStream;
    }
}

