/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.math;

import java.util.Collection;

public class Algebra {
    private Algebra() {
    }

    public static int capToInterval(int lowerBound, int value, int upperBound) {
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static float capToInterval(float lowerBound, float value, float upperBound) {
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static void add3d(float[] out, float[] v1, float[] v2) {
        out[0] = v1[0] + v2[0];
        out[1] = v1[1] + v2[1];
        out[2] = v1[2] + v2[2];
    }

    public static float[] centroid3d(Collection<float[]> vs) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (float[] v : vs) {
            x += v[0];
            y += v[1];
            z += v[2];
        }
        return new float[]{x / (float)vs.size(), y / (float)vs.size(), z / (float)vs.size()};
    }

    public static void subtract3d(float[] out, float[] v1, float[] v2) {
        out[0] = v1[0] - v2[0];
        out[1] = v1[1] - v2[1];
        out[2] = v1[2] - v2[2];
    }

    public static void multiply3d(float[] out, float[][] m, float[] v) {
        float x = v[0];
        float y = v[1];
        float z = v[2];
        out[0] = m[0][0] * x + m[1][0] * y + m[2][0] * z;
        out[1] = m[0][1] * x + m[1][1] * y + m[2][1] * z;
        out[2] = m[0][2] * x + m[1][2] * y + m[2][2] * z;
    }

    public static void multiply3d(float[] out, float[] v, float scalar) {
        out[0] = v[0] * scalar;
        out[1] = v[1] * scalar;
        out[2] = v[2] * scalar;
    }

    public static void divide3d(float[] out, float[] v, float scalar) {
        out[0] = v[0] / scalar;
        out[1] = v[1] / scalar;
        out[2] = v[2] / scalar;
    }

    public static void crossProduct3d(float[] out, float[] v1, float[] v2) {
        float x1 = v1[0];
        float y1 = v1[1];
        float z1 = v1[2];
        out[0] = y1 * v2[2] - z1 * v2[1];
        out[1] = z1 * v2[0] - x1 * v2[2];
        out[2] = x1 * v2[1] - y1 * v2[0];
    }

    public static float dotProduct3d(float[] v1, float[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static float distanceSquared3d(float[] v1, float[] v2) {
        float dx = v1[0] - v2[0];
        float dy = v1[1] - v2[1];
        float dz = v1[2] - v2[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public static float distance3d(float[] v1, float[] v2) {
        return (float)Math.sqrt(Algebra.distanceSquared3d(v1, v2));
    }

    public static float norm3d(float[] vec3d) {
        return (float)Math.sqrt(Algebra.dotProduct3d(vec3d, vec3d));
    }

    public static void normalize3d(float[] out, float[] v) {
        Algebra.divide3d(out, v, Algebra.norm3d(v));
    }

    public static void multiply4d(float[] out, float[][] m, float[] v) {
        float x = v[0];
        float y = v[1];
        float z = v[2];
        out[0] = m[0][0] * x + m[0][1] * y + m[0][2] * z + m[0][3];
        out[1] = m[1][0] * x + m[1][1] * y + m[1][2] * z + m[1][3];
        out[2] = m[2][0] * x + m[2][1] * y + m[2][2] * z + m[2][3];
    }

    public static float[][] multiply4d(float[][] matrix4d1, float[][] matrix4d2) {
        return new float[][]{{matrix4d1[0][0] * matrix4d2[0][0] + matrix4d1[0][1] * matrix4d2[1][0] + matrix4d1[0][2] * matrix4d2[2][0] + matrix4d1[0][3] * matrix4d2[3][0], matrix4d1[0][0] * matrix4d2[0][1] + matrix4d1[0][1] * matrix4d2[1][1] + matrix4d1[0][2] * matrix4d2[2][1] + matrix4d1[0][3] * matrix4d2[3][1], matrix4d1[0][0] * matrix4d2[0][2] + matrix4d1[0][1] * matrix4d2[1][2] + matrix4d1[0][2] * matrix4d2[2][2] + matrix4d1[0][3] * matrix4d2[3][2], matrix4d1[0][0] * matrix4d2[0][3] + matrix4d1[0][1] * matrix4d2[1][3] + matrix4d1[0][2] * matrix4d2[2][3] + matrix4d1[0][3] * matrix4d2[3][3]}, {matrix4d1[1][0] * matrix4d2[0][0] + matrix4d1[1][1] * matrix4d2[1][0] + matrix4d1[1][2] * matrix4d2[2][0] + matrix4d1[1][3] * matrix4d2[3][0], matrix4d1[1][0] * matrix4d2[0][1] + matrix4d1[1][1] * matrix4d2[1][1] + matrix4d1[1][2] * matrix4d2[2][1] + matrix4d1[1][3] * matrix4d2[3][1], matrix4d1[1][0] * matrix4d2[0][2] + matrix4d1[1][1] * matrix4d2[1][2] + matrix4d1[1][2] * matrix4d2[2][2] + matrix4d1[1][3] * matrix4d2[3][2], matrix4d1[1][0] * matrix4d2[0][3] + matrix4d1[1][1] * matrix4d2[1][3] + matrix4d1[1][2] * matrix4d2[2][3] + matrix4d1[1][3] * matrix4d2[3][3]}, {matrix4d1[2][0] * matrix4d2[0][0] + matrix4d1[2][1] * matrix4d2[1][0] + matrix4d1[2][2] * matrix4d2[2][0] + matrix4d1[2][3] * matrix4d2[3][0], matrix4d1[2][0] * matrix4d2[0][1] + matrix4d1[2][1] * matrix4d2[1][1] + matrix4d1[2][2] * matrix4d2[2][1] + matrix4d1[2][3] * matrix4d2[3][1], matrix4d1[2][0] * matrix4d2[0][2] + matrix4d1[2][1] * matrix4d2[1][2] + matrix4d1[2][2] * matrix4d2[2][2] + matrix4d1[2][3] * matrix4d2[3][2], matrix4d1[2][0] * matrix4d2[0][3] + matrix4d1[2][1] * matrix4d2[1][3] + matrix4d1[2][2] * matrix4d2[2][3] + matrix4d1[2][3] * matrix4d2[3][3]}, {matrix4d1[3][0] * matrix4d2[0][0] + matrix4d1[3][1] * matrix4d2[1][0] + matrix4d1[3][2] * matrix4d2[2][0] + matrix4d1[3][3] * matrix4d2[3][0], matrix4d1[3][0] * matrix4d2[0][1] + matrix4d1[3][1] * matrix4d2[1][1] + matrix4d1[3][2] * matrix4d2[2][1] + matrix4d1[3][3] * matrix4d2[3][1], matrix4d1[3][0] * matrix4d2[0][2] + matrix4d1[3][1] * matrix4d2[1][2] + matrix4d1[3][2] * matrix4d2[2][2] + matrix4d1[3][3] * matrix4d2[3][2], matrix4d1[3][0] * matrix4d2[0][3] + matrix4d1[3][1] * matrix4d2[1][3] + matrix4d1[3][2] * matrix4d2[2][3] + matrix4d1[3][3] * matrix4d2[3][3]}};
    }

    public static float[][] transpose3d(float[][] rot) {
        return new float[][]{{rot[0][0], rot[1][0], rot[2][0]}, {rot[0][1], rot[1][1], rot[2][1]}, {rot[0][2], rot[1][2], rot[2][2]}};
    }

    public static float[][] composeTransformationMatrix(float[][] rotation3x3, float[] translation3d) {
        float[][] matrix = new float[4][];
        for (int i = 0; i < 3; ++i) {
            matrix[i] = new float[4];
            System.arraycopy(rotation3x3[i], 0, matrix[i], 0, 3);
            matrix[i][3] = translation3d[i];
        }
        matrix[3] = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        return matrix;
    }
}

