/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.strucmotif.math;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Partition<T>
extends AbstractList<List<T>> {
    private final List<T> list;
    private final int chunkSize;

    public Partition(Collection<T> list, int chunkSize) {
        this.list = new ArrayList<T>(list);
        Collections.shuffle(this.list);
        this.chunkSize = chunkSize;
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.chunkSize;
        int end = Math.min(start + this.chunkSize, this.list.size());
        if (start > end) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of the list range <0," + (this.size() - 1) + ">");
        }
        return new ArrayList<T>(this.list.subList(start, end));
    }

    @Override
    public int size() {
        return (int)Math.ceil((double)this.list.size() / (double)this.chunkSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Partition partition = (Partition)o;
        return this.chunkSize == partition.chunkSize && Objects.equals(this.list, partition.list);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.list, this.chunkSize);
    }
}

