/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SequenceInt32
implements DynamicSequence {
    int[] data;
    int numelements;

    public SequenceInt32() {
        this(10);
    }

    public SequenceInt32(int capacity) {
        this.data = new int[capacity];
        this.numelements = 0;
    }

    private void resizeArray(int size) {
        int[] newData = new int[size];
        System.arraycopy(this.data, 0, newData, 0, Math.min(newData.length, this.data.length));
        this.data = newData;
    }

    @Override
    public void trimToSize() {
        this.resizeArray(this.numelements);
    }

    @Override
    public void aggressiveTrimToSize() {
        this.trimToSize();
    }

    @Override
    public long get(long position) {
        if (position < 0L || position >= (long)this.numelements) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[(int)position];
    }

    @Override
    public void set(long position, long value) {
        if (position < 0L || position >= (long)this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        this.data[(int)position] = (int)value;
        this.numelements = (int)Math.max((long)this.numelements, position + 1L);
    }

    @Override
    public void append(long value) {
        assert (value >= 0L && value <= Integer.MAX_VALUE);
        if (this.data.length < this.numelements + 1) {
            this.resizeArray(this.data.length * 2);
        }
        this.data[this.numelements++] = (int)value;
    }

    @Override
    public long getNumberOfElements() {
        return this.numelements;
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        output.write(2);
        IOUtil.writeInt(output, this.numelements);
        for (int i = 0; i < this.numelements; ++i) {
            IOUtil.writeInt(output, this.data[i]);
        }
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        int type = input.read();
        if (type != 2) {
            throw new IllegalFormatException("Trying to read INT32 but data is not INT32");
        }
        int size = IOUtil.readInt(input);
        if (size < 0) {
            throw new IOException("Cannot load values bigger than 2Gb with this data structure");
        }
        this.numelements = 0;
        this.data = new int[size];
        for (long i = 0L; i < (long)size; ++i) {
            this.append(IOUtil.readInt(input));
        }
    }

    @Override
    public void add(Iterator<Long> iterator) {
        while (iterator.hasNext()) {
            long value = iterator.next();
            this.append(value);
        }
    }

    public void addIntegers(List<Integer> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            long value = elements.get(i).longValue();
            this.append(value);
        }
    }

    public String toString() {
        throw new NotImplementedException();
    }

    @Override
    public long size() {
        return 4 * this.numelements;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#seqInt32>";
    }

    @Override
    public void close() throws IOException {
        this.data = null;
    }
}

