/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary;

import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionaryBig;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.HashDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.PSFCFourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.PSFCTempDictionary;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;

public class DictionaryFactory {
    public static final String MOD_DICT_IMPL_HASH = "hash";
    public static final String MOD_DICT_IMPL_MULT_HASH = "multHash";
    public static final String MOD_DICT_IMPL_HASH_PSFC = "hashPsfc";
    public static final String DICTIONARY_TYPE_FOUR_SECTION_BIG = "dictionaryFourBig";
    public static final String DICTIONARY_TYPE_MULTI_OBJECTS = "dictionaryMultiObj";

    private DictionaryFactory() {
    }

    public static Dictionary createDefaultDictionary() throws IllegalArgumentException {
        return new FourSectionDictionary(new HDTSpecification());
    }

    public static TempDictionary createTempDictionary(HDTOptions spec) {
        String name = spec.get("tempDictionary.impl");
        if (name == null || "".equals(name) || MOD_DICT_IMPL_HASH.equals(name)) {
            return new HashDictionary(spec, false);
        }
        if (MOD_DICT_IMPL_HASH_PSFC.equals(name)) {
            return new PSFCTempDictionary(new HashDictionary(spec, false));
        }
        if (MOD_DICT_IMPL_MULT_HASH.equals(name)) {
            return new HashDictionary(spec, true);
        }
        throw new IllegalFormatException("Implementation of triples not found for " + name);
    }

    public static DictionaryPrivate createDictionary(HDTOptions spec) {
        String name = spec.get("dictionary.type");
        if (name == null || "<http://purl.org/HDT/hdt#dictionaryFour>".equals(name)) {
            return new FourSectionDictionary(spec);
        }
        if ("<http://purl.org/HDT/hdt#dictionaryFourPsfc>".equals(name)) {
            return new PSFCFourSectionDictionary(spec);
        }
        if (DICTIONARY_TYPE_FOUR_SECTION_BIG.equals(name)) {
            return new FourSectionDictionaryBig(spec);
        }
        if (DICTIONARY_TYPE_MULTI_OBJECTS.equals(name)) {
            return new MultipleSectionDictionary(spec);
        }
        throw new IllegalFormatException("Implementation of dictionary not found for " + name);
    }

    public static DictionaryPrivate createDictionary(ControlInfo ci) {
        String name = ci.getFormat();
        if ("<http://purl.org/HDT/hdt#dictionaryFour>".equals(name)) {
            return new FourSectionDictionary(new HDTSpecification());
        }
        if ("<http://purl.org/HDT/hdt#dictionaryFourPsfc>".equals(name)) {
            return new PSFCFourSectionDictionary(new HDTSpecification());
        }
        if ("<http://purl.org/HDT/hdt#dictionaryMult>".equals(name)) {
            return new MultipleSectionDictionary(new HDTSpecification());
        }
        throw new IllegalFormatException("Implementation of dictionary not found for " + name);
    }

    public static DictionaryDiff createDictionaryDiff(Dictionary dictionary, String location) {
        String type = dictionary.getType();
        if ("<http://purl.org/HDT/hdt#dictionaryFour>".equals(type) || type.equals("<http://purl.org/HDT/hdt#dictionaryFourPsfc>")) {
            return new FourSectionDictionaryDiff(location);
        }
        if (type.equals("<http://purl.org/HDT/hdt#dictionaryMult>")) {
            return new MultipleSectionDictionaryDiff(location);
        }
        throw new IllegalFormatException("Implementation of DictionaryDiff not found for " + type);
    }
}

