/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.util.TreeMap;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.enums.DictionarySectionRole;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.DelayedString;

public abstract class BaseDictionary
implements DictionaryPrivate {
    protected final HDTOptions spec;
    protected DictionarySectionPrivate subjects;
    protected DictionarySectionPrivate predicates;
    protected DictionarySectionPrivate objects;
    protected DictionarySectionPrivate shared;

    public BaseDictionary(HDTOptions spec) {
        this.spec = spec;
    }

    protected long getGlobalId(long id, DictionarySectionRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                return this.shared.getNumberOfElements() + id;
            }
            case PREDICATE: 
            case SHARED: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    protected long getLocalId(long id, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: 
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return id;
                }
                return id - this.shared.getNumberOfElements();
            }
            case PREDICATE: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    public long stringToId(CharSequence str, TripleComponentRole position) {
        if ((str = DelayedString.unwrap(str)) == null || str.length() == 0) {
            return 0L;
        }
        if (str instanceof String) {
            str = new CompactString(str);
        }
        long ret = 0L;
        switch (position) {
            case SUBJECT: {
                ret = this.shared.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.subjects.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SUBJECT);
                }
                return -1L;
            }
            case PREDICATE: {
                ret = this.predicates.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.PREDICATE);
                }
                return -1L;
            }
            case OBJECT: {
                if (str.charAt(0) != '\"' && (ret = this.shared.locate(str)) != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED);
                }
                ret = this.objects.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.OBJECT);
                }
                return -1L;
            }
        }
        throw new IllegalArgumentException();
    }

    public long getNumberOfElements() {
        return this.subjects.getNumberOfElements() + this.predicates.getNumberOfElements() + this.objects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    public long size() {
        return this.subjects.size() + this.predicates.size() + this.objects.size() + this.shared.size();
    }

    public long getNsubjects() {
        return this.subjects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    public long getNpredicates() {
        return this.predicates.getNumberOfElements();
    }

    public long getNobjects() {
        return this.objects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    public long getNshared() {
        return this.shared.getNumberOfElements();
    }

    public DictionarySection getSubjects() {
        return this.subjects;
    }

    public DictionarySection getPredicates() {
        return this.predicates;
    }

    public DictionarySection getObjects() {
        return this.objects;
    }

    public DictionarySection getShared() {
        return this.shared;
    }

    private DictionarySectionPrivate getSection(long id, TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return this.shared;
                }
                return this.subjects;
            }
            case PREDICATE: {
                return this.predicates;
            }
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return this.shared;
                }
                return this.objects;
            }
        }
        throw new IllegalArgumentException();
    }

    public CharSequence idToString(long id, TripleComponentRole role) {
        DictionarySectionPrivate section = this.getSection(id, role);
        long localId = this.getLocalId(id, role);
        return section.extract(localId);
    }

    public String dataTypeOfId(long id) {
        try {
            throw new IllegalAccessException("Method is not applicable on this dictionary");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "";
        }
    }

    public TreeMap<String, DictionarySection> getAllObjects() {
        try {
            throw new IllegalAccessException("Method is not applicable on this dictionary");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getNAllObjects() {
        try {
            throw new IllegalAccessException("Method is not applicable on this dictionary");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

