/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIntersection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.dictionary.impl.utilCat.SectionUtil;
import org.rdfhdt.hdt.dictionary.impl.utilDiff.DiffWrapper;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;

public class FourSectionDictionaryDiff
implements DictionaryDiff {
    private final String location;
    private final HashMap<String, CatMapping> allMappings = new HashMap();
    private CatMapping mappingBack;
    public long numShared;

    public FourSectionDictionaryDiff(String location) {
        this.location = location;
    }

    @Override
    public void diff(Dictionary dictionary, Map<String, ModifiableBitmap> bitmaps, ProgressListener listener) throws IOException {
        this.allMappings.put("predicate", new CatMapping(this.location, "predicate", dictionary.getPredicates().getNumberOfElements()));
        this.allMappings.put("subject", new CatMapping(this.location, "subject", dictionary.getSubjects().getNumberOfElements()));
        this.allMappings.put("object", new CatMapping(this.location, "object", dictionary.getObjects().getNumberOfElements()));
        this.allMappings.put("shared", new CatMapping(this.location, "shared", dictionary.getShared().getNumberOfElements()));
        Bitmap predicatesBitMap = (Bitmap)bitmaps.get("P");
        Iterator predicates = dictionary.getPredicates().getSortedEntries();
        DiffWrapper itSkipPreds = new DiffWrapper(predicates, predicatesBitMap, "predicate");
        ArrayList<Iterator<CatElement>> listSkipPred = new ArrayList<Iterator<CatElement>>();
        listSkipPred.add(itSkipPreds);
        long numPreds = predicatesBitMap.countOnes();
        SectionUtil.createSection(this.location, numPreds, 4, new CatUnion(listSkipPred), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap subjectsBitMap = (Bitmap)bitmaps.get("S");
        Iterator subjects = dictionary.getSubjects().getSortedEntries();
        DiffWrapper itSkipSubs = new DiffWrapper(subjects, subjectsBitMap, "subject");
        ArrayList<Iterator<CatElement>> listSkipSubj = new ArrayList<Iterator<CatElement>>();
        listSkipSubj.add(itSkipSubs);
        SharedWrapper sharedWrapper = new SharedWrapper(0, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        long numNewSubj = sharedWrapper.count();
        sharedWrapper = new SharedWrapper(0, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        listSkipSubj.add(sharedWrapper);
        long numSubj = subjectsBitMap.countOnes() + numNewSubj;
        SectionUtil.createSection(this.location, numSubj, 2, new CatUnion(listSkipSubj), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap objectsBitMap = (Bitmap)bitmaps.get("O");
        Iterator objects = dictionary.getObjects().getSortedEntries();
        DiffWrapper itSkipObjs = new DiffWrapper(objects, objectsBitMap, "object");
        ArrayList<Iterator<CatElement>> listSkipObjs = new ArrayList<Iterator<CatElement>>();
        listSkipObjs.add(itSkipObjs);
        sharedWrapper = new SharedWrapper(1, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        long numNewObj = sharedWrapper.count();
        sharedWrapper = new SharedWrapper(1, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        listSkipObjs.add(sharedWrapper);
        long numObject = objectsBitMap.countOnes() + numNewObj;
        SectionUtil.createSection(this.location, numObject, 3, new CatUnion(listSkipObjs), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap sharedSubjBitMap = (Bitmap)bitmaps.get("SH_S");
        Bitmap sharedObjBitMap = (Bitmap)bitmaps.get("SH_O");
        Iterator shared = dictionary.getShared().getSortedEntries();
        DiffWrapper sharedSubj = new DiffWrapper(shared, sharedSubjBitMap, "shared");
        shared = dictionary.getShared().getSortedEntries();
        DiffWrapper sharedObj = new DiffWrapper(shared, sharedObjBitMap, "shared");
        ArrayList<Iterator<CatElement>> listShared = new ArrayList<Iterator<CatElement>>();
        listShared.add(new CatIntersection(sharedSubj, sharedObj));
        CatUnion union = new CatUnion(listShared);
        while (union.hasNext()) {
            union.next();
            ++this.numShared;
        }
        listShared = new ArrayList();
        sharedSubj = new DiffWrapper(dictionary.getShared().getSortedEntries(), sharedSubjBitMap, "shared");
        sharedObj = new DiffWrapper(dictionary.getShared().getSortedEntries(), sharedObjBitMap, "shared");
        listShared.add(new CatIntersection(sharedSubj, sharedObj));
        SectionUtil.createSection(this.location, this.numShared, 1, new CatUnion(listShared), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(dictionary.getType());
        ci.setInt("elements", numSubj + numPreds + numObject + this.numShared);
        try (FileOutputStream outFinal = new FileOutputStream(this.location + "dictionary");){
            ci.save(outFinal);
            byte[] buf = new byte[100000];
            for (int i = 1; i <= 4; ++i) {
                int j = i;
                if (i == 4) {
                    j = 3;
                } else if (j == 3) {
                    j = 4;
                }
                try (FileInputStream in = new FileInputStream(this.location + "section" + j);){
                    int b;
                    while ((b = ((InputStream)in).read(buf)) >= 0) {
                        ((OutputStream)outFinal).write(buf, 0, b);
                        outFinal.flush();
                    }
                }
                Files.delete(Paths.get(this.location + "section" + j, new String[0]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mappingBack = new CatMapping(this.location, "back", numSubj + this.numShared);
        if (this.mappingBack.getSize() > 0L) {
            int i = 0;
            while ((long)i < this.allMappings.get("shared").getSize()) {
                long type = this.allMappings.get("shared").getType(i);
                if (type == 1L) {
                    this.mappingBack.set(this.allMappings.get("shared").getMapping(i) - 1L, i + 1, 1);
                } else if (type == 2L) {
                    this.mappingBack.set(this.allMappings.get("shared").getMapping(i) + this.numShared - 1L, i + 1, 2);
                }
                ++i;
            }
            i = 0;
            while ((long)i < this.allMappings.get("subject").getSize()) {
                long type = this.allMappings.get("subject").getType(i);
                if (type == 1L) {
                    this.mappingBack.set(this.allMappings.get("subject").getMapping(i) - 1L, i + 1 + (int)dictionary.getNshared(), 1);
                } else if (type == 2L) {
                    this.mappingBack.set(this.allMappings.get("subject").getMapping(i) + this.numShared - 1L, i + 1 + (int)dictionary.getNshared(), 2);
                }
                ++i;
            }
        }
    }

    @Override
    public HashMap<String, CatMapping> getAllMappings() {
        return this.allMappings;
    }

    @Override
    public CatMapping getMappingBack() {
        return this.mappingBack;
    }

    @Override
    public long getNumShared() {
        return this.numShared;
    }

    private static class SharedWrapper
    implements Iterator<CatElement> {
        private final Bitmap bitmapSub;
        private final Bitmap bitmapObj;
        private final Iterator<? extends CharSequence> sectionIter;
        private final int flag;
        private CatElement next;
        private long count = 0L;

        public SharedWrapper(int flag, Bitmap bitmapSub, Bitmap bitmapObj, Iterator<? extends CharSequence> sectionIter) {
            this.bitmapSub = bitmapSub;
            this.bitmapObj = bitmapObj;
            this.sectionIter = sectionIter;
            this.flag = flag;
        }

        @Override
        public boolean hasNext() {
            while (this.sectionIter.hasNext()) {
                CharSequence element = this.sectionIter.next();
                if (this.flag == 0 && this.bitmapSub.access(this.count) && !this.bitmapObj.access(this.count) || this.flag == 1 && this.bitmapObj.access(this.count) && !this.bitmapSub.access(this.count)) {
                    ArrayList<CatElement.IteratorPlusPosition> IDs = new ArrayList<CatElement.IteratorPlusPosition>();
                    IDs.add(new CatElement.IteratorPlusPosition("shared", this.count + 1L));
                    this.next = new CatElement(element, IDs);
                    ++this.count;
                    return true;
                }
                ++this.count;
            }
            return false;
        }

        @Override
        public CatElement next() {
            return this.next;
        }

        public int count() {
            int i = 0;
            while (this.hasNext()) {
                ++i;
            }
            return i;
        }
    }
}

