/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.OptimizedExtractor;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionMap;
import org.rdfhdt.hdt.dictionary.impl.section.PFCOptimizedExtractor;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.util.LiteralsUtils;

public class MultDictionaryPFCOptimizedExtractor
implements OptimizedExtractor {
    private final PFCOptimizedExtractor shared;
    private final PFCOptimizedExtractor subjects;
    private final PFCOptimizedExtractor predicates;
    private final TreeMap<String, PFCOptimizedExtractor> objects;
    private final long numshared;

    public MultDictionaryPFCOptimizedExtractor(MultipleSectionDictionary origDict) {
        this.numshared = (int)origDict.getNshared();
        this.shared = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.shared);
        this.subjects = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.subjects);
        this.predicates = new PFCOptimizedExtractor((PFCDictionarySectionMap)origDict.predicates);
        this.objects = new TreeMap();
        for (Map.Entry<String, DictionarySection> entry : origDict.getAllObjects().entrySet()) {
            this.objects.put(entry.getKey(), new PFCOptimizedExtractor((PFCDictionarySectionMap)entry.getValue()));
        }
    }

    @Override
    public CharSequence idToString(long id, TripleComponentRole role) {
        AbstractMap.SimpleEntry<String, PFCOptimizedExtractor> section = this.getSection(id, role);
        long localId = this.getLocalId(id, role);
        if (section.getKey().equals("NO_DATATYPE") || section.getKey().equals("section")) {
            return section.getValue().extract(localId);
        }
        String label = section.getValue().extract(localId).toString();
        String dType = section.getKey();
        if (LiteralsUtils.containsLanguage(label)) {
            return label;
        }
        return label + "^^" + dType;
    }

    private AbstractMap.SimpleEntry<String, PFCOptimizedExtractor> getSection(long id, TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                if (id <= this.numshared) {
                    return new AbstractMap.SimpleEntry<String, PFCOptimizedExtractor>("section", this.shared);
                }
                return new AbstractMap.SimpleEntry<String, PFCOptimizedExtractor>("section", this.subjects);
            }
            case PREDICATE: {
                return new AbstractMap.SimpleEntry<String, PFCOptimizedExtractor>("section", this.predicates);
            }
            case OBJECT: {
                if (id <= this.numshared) {
                    return new AbstractMap.SimpleEntry<String, PFCOptimizedExtractor>("section", this.shared);
                }
                Iterator<Map.Entry<String, PFCOptimizedExtractor>> hmIterator = this.objects.entrySet().iterator();
                PFCOptimizedExtractor desiredSection = null;
                String type = "";
                int count = 0;
                while (hmIterator.hasNext()) {
                    Map.Entry<String, PFCOptimizedExtractor> entry = hmIterator.next();
                    PFCOptimizedExtractor subSection = entry.getValue();
                    if (id > this.numshared + (long)(count = (int)((long)count + subSection.getNumStrings()))) continue;
                    desiredSection = subSection;
                    type = entry.getKey();
                    break;
                }
                return new AbstractMap.SimpleEntry<String, Object>(type, desiredSection);
            }
        }
        throw new IllegalArgumentException();
    }

    private long getLocalId(long id, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: {
                if (id <= this.numshared) {
                    return id;
                }
                return id - this.numshared;
            }
            case OBJECT: {
                if (id <= this.numshared) {
                    return id;
                }
                Iterator<Map.Entry<String, PFCOptimizedExtractor>> hmIterator = this.objects.entrySet().iterator();
                long count = 0L;
                while (hmIterator.hasNext()) {
                    Map.Entry<String, PFCOptimizedExtractor> entry = hmIterator.next();
                    PFCOptimizedExtractor subSection = entry.getValue();
                    if (id > this.numshared + (count += subSection.getNumStrings())) continue;
                    count -= subSection.getNumStrings();
                    break;
                }
                return id - count - this.numshared;
            }
            case PREDICATE: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }
}

