/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.impl.section.PFCOptimizedExtractor;
import org.rdfhdt.hdt.enums.DictionarySectionRole;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.DelayedString;

public abstract class MultipleBaseDictionary
implements DictionaryPrivate {
    protected final HDTOptions spec;
    protected DictionarySectionPrivate subjects;
    protected DictionarySectionPrivate predicates;
    protected TreeMap<String, DictionarySectionPrivate> objects;
    protected DictionarySectionPrivate shared;
    static Pattern pattern = Pattern.compile("@[a-zA-Z0-9\\-]+$");

    public MultipleBaseDictionary(HDTOptions spec) {
        this.spec = spec;
    }

    protected long getGlobalId(long id, DictionarySectionRole position, CharSequence str) {
        switch (position) {
            case SUBJECT: {
                return id + this.shared.getNumberOfElements();
            }
            case OBJECT: {
                Iterator<Map.Entry<String, DictionarySectionPrivate>> iter = this.objects.entrySet().iterator();
                int count = 0;
                while (iter.hasNext()) {
                    Map.Entry<String, DictionarySectionPrivate> entry = iter.next();
                    count = (int)((long)count + entry.getValue().getNumberOfElements());
                    if (!LiteralsUtils.getType(str).equals(entry.getKey())) continue;
                    count = (int)((long)count - entry.getValue().getNumberOfElements());
                    break;
                }
                return this.shared.getNumberOfElements() + (long)count + id;
            }
            case PREDICATE: 
            case SHARED: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    protected long getLocalId(long id, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return id;
                }
                return id - this.shared.getNumberOfElements();
            }
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return id;
                }
                Iterator<Map.Entry<String, DictionarySectionPrivate>> hmIterator = this.objects.entrySet().iterator();
                long count = 0L;
                while (hmIterator.hasNext()) {
                    Map.Entry<String, DictionarySectionPrivate> entry = hmIterator.next();
                    long numElts = 0L;
                    if (entry.getValue() instanceof DictionarySectionPrivate) {
                        numElts = entry.getValue().getNumberOfElements();
                    } else if (entry.getValue() instanceof PFCOptimizedExtractor) {
                        numElts = ((PFCOptimizedExtractor)((Object)entry.getValue())).getNumStrings();
                    }
                    if (id > this.shared.getNumberOfElements() + (count += numElts)) continue;
                    count -= numElts;
                    break;
                }
                return id - count - this.shared.getNumberOfElements();
            }
            case PREDICATE: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    public long stringToId(CharSequence str, TripleComponentRole position) {
        if ((str = DelayedString.unwrap(str)) == null || str.length() == 0) {
            return 0L;
        }
        if (str instanceof String) {
            str = new CompactString(str);
        }
        long ret = 0L;
        switch (position) {
            case SUBJECT: {
                ret = this.shared.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED, str);
                }
                ret = this.subjects.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SUBJECT, str);
                }
                return -1L;
            }
            case PREDICATE: {
                ret = this.predicates.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.PREDICATE, str);
                }
                return -1L;
            }
            case OBJECT: {
                if (str.charAt(0) != '\"' && (ret = this.shared.locate(str)) != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED, str);
                }
                DictionarySectionPrivate subSection = this.getSubSection(str);
                if (subSection == null) {
                    return -1L;
                }
                ret = subSection.locate(new CompactString(LiteralsUtils.removeType(str)));
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.OBJECT, str);
                }
                return -1L;
            }
        }
        throw new IllegalArgumentException();
    }

    private long getNumberObjectsAllSections() {
        Iterator<Map.Entry<String, DictionarySectionPrivate>> hmIterator = this.objects.entrySet().iterator();
        long total = 0L;
        while (hmIterator.hasNext()) {
            Map.Entry<String, DictionarySectionPrivate> entry = hmIterator.next();
            DictionarySectionPrivate subSection = entry.getValue();
            total += subSection.getNumberOfElements();
        }
        return total;
    }

    public long getNumberOfElements() {
        return this.subjects.getNumberOfElements() + this.predicates.getNumberOfElements() + this.getNumberObjectsAllSections() + this.shared.getNumberOfElements();
    }

    public long size() {
        return this.subjects.size() + this.predicates.size() + (long)this.objects.size() + this.shared.size();
    }

    public long getNsubjects() {
        return this.subjects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    public long getNpredicates() {
        return this.predicates.getNumberOfElements();
    }

    public long getNobjects() {
        return this.getNumberObjectsAllSections() + this.shared.getNumberOfElements();
    }

    public long getNshared() {
        return this.shared.getNumberOfElements();
    }

    public DictionarySection getSubjects() {
        return this.subjects;
    }

    public DictionarySection getPredicates() {
        return this.predicates;
    }

    public TreeMap<String, DictionarySection> getAllObjects() {
        return new TreeMap<String, DictionarySection>((SortedMap<String, DictionarySection>)this.objects);
    }

    public DictionarySection getObjects() {
        return null;
    }

    public DictionarySection getShared() {
        return this.shared;
    }

    private AbstractMap.SimpleEntry<String, DictionarySectionPrivate> getSection(long id, TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return new AbstractMap.SimpleEntry<String, DictionarySectionPrivate>("section", this.shared);
                }
                return new AbstractMap.SimpleEntry<String, DictionarySectionPrivate>("section", this.subjects);
            }
            case PREDICATE: {
                return new AbstractMap.SimpleEntry<String, DictionarySectionPrivate>("section", this.predicates);
            }
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return new AbstractMap.SimpleEntry<String, DictionarySectionPrivate>("section", this.shared);
                }
                Iterator<Map.Entry<String, DictionarySectionPrivate>> hmIterator = this.objects.entrySet().iterator();
                DictionarySectionPrivate desiredSection = null;
                String type = "";
                int count = 0;
                while (hmIterator.hasNext()) {
                    Map.Entry<String, DictionarySectionPrivate> entry = hmIterator.next();
                    DictionarySectionPrivate subSection = entry.getValue();
                    count = (int)((long)count + subSection.getNumberOfElements());
                    if (id > this.shared.getNumberOfElements() + (long)count) continue;
                    desiredSection = subSection;
                    type = entry.getKey();
                    break;
                }
                return new AbstractMap.SimpleEntry<String, Object>(type, desiredSection);
            }
        }
        throw new IllegalArgumentException();
    }

    public CharSequence idToString(long id, TripleComponentRole role) {
        AbstractMap.SimpleEntry<String, DictionarySectionPrivate> section = this.getSection(id, role);
        long localId = this.getLocalId(id, role);
        if (section.getKey().equals("NO_DATATYPE") || section.getKey().equals("section")) {
            return section.getValue().extract(localId);
        }
        if (section.getValue() == null) {
            System.out.println("Error couldn't find the section for the given ID: [" + id + "]");
            return null;
        }
        String label = section.getValue().extract(localId).toString();
        String dType = section.getKey();
        if (LiteralsUtils.containsLanguage(label)) {
            return label;
        }
        return label + "^^" + dType;
    }

    private DictionarySectionPrivate getSubSection(CharSequence str) {
        String dataType = "";
        dataType = LiteralsUtils.getType(str);
        return this.objects.get(dataType);
    }

    public String dataTypeOfId(long id) {
        return this.getSection(id, TripleComponentRole.OBJECT).getKey();
    }

    public AbstractMap.SimpleEntry<Long, Long> getDataTypeRange(String dataType) {
        if (!((String)dataType).equals("NO_DATATYPE")) {
            dataType = "<" + (String)dataType + ">";
        }
        if (this.objects.containsKey(dataType)) {
            Iterator<Map.Entry<String, DictionarySectionPrivate>> iter = this.objects.entrySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Map.Entry<String, DictionarySectionPrivate> entry = iter.next();
                count = (int)((long)count + entry.getValue().getNumberOfElements());
                if (!((String)dataType).equals(entry.getKey())) continue;
                count = (int)((long)count - entry.getValue().getNumberOfElements());
                break;
            }
            long offset = this.shared.getNumberOfElements() + (long)count;
            long size = offset + this.objects.get(dataType).getNumberOfElements();
            return new AbstractMap.SimpleEntry<Long, Long>(offset + 1L, size);
        }
        return new AbstractMap.SimpleEntry<Long, Long>(0L, 0L);
    }
}

