/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleBaseDictionary;
import org.rdfhdt.hdt.dictionary.impl.section.DictionarySectionFactory;
import org.rdfhdt.hdt.dictionary.impl.section.HashDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySection;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.CustomIterator;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.string.CompactString;

public class MultipleSectionDictionary
extends MultipleBaseDictionary {
    public MultipleSectionDictionary(HDTOptions spec) {
        super(spec);
        this.subjects = new PFCDictionarySection(spec);
        this.predicates = new PFCDictionarySection(spec);
        this.objects = new TreeMap();
        this.shared = new PFCDictionarySection(spec);
    }

    @Override
    public void load(TempDictionary other, ProgressListener listener) {
        IntermediateListener iListener = new IntermediateListener(listener);
        this.subjects.load(other.getSubjects(), (ProgressListener)iListener);
        this.predicates.load(other.getPredicates(), (ProgressListener)iListener);
        Iterator<? extends CharSequence> iter = other.getObjects().getEntries();
        HashMap<String, Long> literalsCounts = ((HashDictionarySection)other.getObjects()).getLiteralsCounts();
        if (literalsCounts.containsKey("NO_DATATYPE")) {
            literalsCounts.put("NO_DATATYPE", literalsCounts.get("NO_DATATYPE") - other.getShared().getNumberOfElements());
        }
        CustomIterator customIterator = new CustomIterator(iter, literalsCounts);
        long startTime = System.currentTimeMillis();
        while (customIterator.hasNext()) {
            PFCDictionarySection section = new PFCDictionarySection(this.spec);
            String type = LiteralsUtils.getType(customIterator.prev);
            long numEntries = literalsCounts.get(type);
            section.load(customIterator, numEntries, listener);
            long locate = section.locate(new CompactString("\"\ud83c\uddeb\ud83c\uddf7\"@ro"));
            this.objects.put(type, section);
        }
        long endTime = System.currentTimeMillis();
        this.shared.load(other.getShared(), (ProgressListener)iListener);
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(this.getType());
        ci.setInt("elements", this.getNumberOfElements());
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared.save(output, iListener);
        this.subjects.save(output, iListener);
        this.predicates.save(output, iListener);
        this.writeLiteralsMap(output, iListener);
    }

    private void writeLiteralsMap(OutputStream output, ProgressListener listener) throws IOException {
        Iterator hmIterator = this.objects.entrySet().iterator();
        int numberOfTypes = this.objects.size();
        output.write(numberOfTypes);
        ArrayList<String> types = new ArrayList<String>();
        while (hmIterator.hasNext()) {
            Map.Entry entry = hmIterator.next();
            String uri = (String)entry.getKey();
            output.write(uri.length());
            IOUtil.writeBuffer(output, uri.getBytes(), 0, uri.getBytes().length, listener);
            types.add(uri);
        }
        for (String type : types) {
            ((DictionarySectionPrivate)this.objects.get(type)).save(output, listener);
        }
    }

    private void readLiteralsMap(InputStream input, ProgressListener listener) throws IOException {
        int numberOfTypes = input.read();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < numberOfTypes; ++i) {
            int length = input.read();
            byte[] type = IOUtil.readBuffer(input, length, listener);
            types.add(new String(type));
        }
        for (String type : types) {
            this.objects.put(type, DictionarySectionFactory.loadFrom(input, listener));
        }
    }

    private void mapLiteralsMap(CountInputStream input, File f, ProgressListener listener) throws IOException {
        int numberOfTypes = input.read();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < numberOfTypes; ++i) {
            int length = input.read();
            byte[] type = IOUtil.readBuffer(input, length, listener);
            String typeStr = new String(type);
            types.add(typeStr);
        }
        for (String type : types) {
            this.objects.put(type, DictionarySectionFactory.loadFrom(input, f, listener));
        }
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        if (ci.getType() != ControlInfo.Type.DICTIONARY) {
            throw new IllegalFormatException("Trying to read a dictionary section, but was not dictionary.");
        }
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared = DictionarySectionFactory.loadFrom(input, iListener);
        this.subjects = DictionarySectionFactory.loadFrom(input, iListener);
        this.predicates = DictionarySectionFactory.loadFrom(input, iListener);
        this.readLiteralsMap(input, listener);
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        ci.load(in);
        if (ci.getType() != ControlInfo.Type.DICTIONARY) {
            throw new IllegalFormatException("Trying to read a dictionary section, but was not dictionary.");
        }
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.subjects = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.predicates = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.mapLiteralsMap(in, f, listener);
    }

    public long getNAllObjects() {
        Iterator hmIterator = this.objects.entrySet().iterator();
        long count = 0L;
        while (hmIterator.hasNext()) {
            Map.Entry entry = hmIterator.next();
            count += ((DictionarySectionPrivate)entry.getValue()).getNumberOfElements();
        }
        return count;
    }

    @Override
    public TreeMap<String, DictionarySection> getAllObjects() {
        return new TreeMap<String, DictionarySection>(this.objects);
    }

    public void populateHeader(Header header, String rootNode) {
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarynumSharedSubjectObject>", this.getNshared());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarysizeStrings>", this.size());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#dictionaryMult>";
    }

    public void close() throws IOException {
        this.shared.close();
        this.subjects.close();
        this.predicates.close();
        for (Map.Entry entry : this.objects.entrySet()) {
            ((DictionarySectionPrivate)entry.getValue()).close();
        }
    }
}

