/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryCat;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIntersection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMappingBack;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatWrapper;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.rdfhdt.hdt.util.string.ByteStringUtil;

public class MultipleSectionDictionaryCat
implements DictionaryCat {
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int BLOCK_PER_BUFFER = 1000000;
    private static final String NO_DT_OBJECTS = "NO_DATATYPE";
    private final String location;
    private long numShared;
    private final HashMap<String, CatMapping> allMappings = new HashMap();
    private CatMappingBack mappingS;

    public MultipleSectionDictionaryCat(String location) {
        this.location = location;
    }

    @Override
    public void cat(Dictionary dictionary1, Dictionary dictionary2, ProgressListener listener) throws IOException {
        long newId;
        int i;
        CatMapping mapping;
        String dataType;
        int i2;
        CatIntersection i22;
        this.allMappings.put("P1", new CatMapping(this.location, "P1", dictionary1.getPredicates().getNumberOfElements()));
        this.allMappings.put("P2", new CatMapping(this.location, "P2", dictionary2.getPredicates().getNumberOfElements()));
        this.allMappings.put("S1", new CatMapping(this.location, "S1", dictionary1.getSubjects().getNumberOfElements()));
        this.allMappings.put("S2", new CatMapping(this.location, "S2", dictionary2.getSubjects().getNumberOfElements()));
        this.allMappings.put("O1", new CatMapping(this.location, "O1", dictionary1.getNAllObjects()));
        this.allMappings.put("O2", new CatMapping(this.location, "O2", dictionary2.getNAllObjects()));
        this.allMappings.put("SH1", new CatMapping(this.location, "SH1", dictionary1.getShared().getNumberOfElements()));
        this.allMappings.put("SH2", new CatMapping(this.location, "SH2", dictionary2.getShared().getNumberOfElements()));
        Iterator hmIterator1 = dictionary1.getAllObjects().entrySet().iterator();
        int countSubSections1 = 0;
        int countSubSections2 = 0;
        while (hmIterator1.hasNext()) {
            Map.Entry entry = hmIterator1.next();
            Object prefix = "sub" + countSubSections1;
            if (((String)entry.getKey()).equals(NO_DT_OBJECTS)) {
                prefix = (String)entry.getKey();
            }
            this.allMappings.put((String)prefix + "1", new CatMapping(this.location, (String)prefix + "1", ((DictionarySection)entry.getValue()).getNumberOfElements()));
            ++countSubSections1;
        }
        for (Map.Entry entry : dictionary2.getAllObjects().entrySet()) {
            Object prefix = "sub" + countSubSections2;
            if (((String)entry.getKey()).equals(NO_DT_OBJECTS)) {
                prefix = (String)entry.getKey();
            }
            this.allMappings.put((String)prefix + "2", new CatMapping(this.location, (String)prefix + "2", ((DictionarySection)entry.getValue()).getNumberOfElements()));
            ++countSubSections2;
        }
        System.out.println("PREDICATES-------------------");
        int numCommonPredicates = 0;
        CatIntersection commonP1P2 = new CatIntersection(new CatWrapper(dictionary1.getPredicates().getSortedEntries(), "P1"), new CatWrapper(dictionary2.getPredicates().getSortedEntries(), "P2"));
        while (commonP1P2.hasNext()) {
            commonP1P2.next();
            ++numCommonPredicates;
        }
        long numPredicates = dictionary1.getPredicates().getNumberOfElements() + dictionary2.getPredicates().getNumberOfElements() - (long)numCommonPredicates;
        ArrayList<Iterator<CatElement>> addPredicatesList = new ArrayList<Iterator<CatElement>>();
        addPredicatesList.add(new CatWrapper(dictionary1.getPredicates().getSortedEntries(), "P1"));
        addPredicatesList.add(new CatWrapper(dictionary2.getPredicates().getSortedEntries(), "P2"));
        CatUnion itAddPredicates = new CatUnion(addPredicatesList);
        this.catSection(numPredicates, 3, itAddPredicates, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, listener);
        System.out.println("SUBJECTS-------------------");
        ArrayList<Iterator<CatElement>> skipSubjectList = new ArrayList<Iterator<CatElement>>();
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2")));
        if (dictionary2.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2")));
        }
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"), new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1")));
        if (dictionary1.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"), new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1")));
        }
        CatUnion skipSubject = new CatUnion(skipSubjectList);
        int numSkipSubjects = 0;
        while (skipSubject.hasNext()) {
            skipSubject.next();
            ++numSkipSubjects;
        }
        int numCommonSubjects = 0;
        CatIntersection commonS1S2 = new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"));
        while (commonS1S2.hasNext()) {
            commonS1S2.next();
            ++numCommonSubjects;
        }
        long numSubjects = dictionary1.getSubjects().getNumberOfElements() + dictionary2.getSubjects().getNumberOfElements() - (long)numCommonSubjects - (long)numSkipSubjects;
        skipSubjectList = new ArrayList();
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2")));
        if (dictionary2.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2")));
        }
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"), new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1")));
        if (dictionary1.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"), new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1")));
        }
        skipSubject = new CatUnion(skipSubjectList);
        ArrayList<Iterator<CatElement>> addSubjectsList = new ArrayList<Iterator<CatElement>>();
        addSubjectsList.add(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"));
        addSubjectsList.add(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"));
        CatUnion itAddSubjects = new CatUnion(addSubjectsList);
        this.catSection(numSubjects, 2, itAddSubjects, skipSubject, this.allMappings, listener);
        System.out.println("OBJECTS-------------------");
        ArrayList<Iterator<CatElement>> skipObjectsList = new ArrayList<Iterator<CatElement>>();
        if (dictionary1.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2")));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1"), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2")));
        }
        if (dictionary2.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2"), new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1")));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2"), new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1")));
        }
        CatUnion skipObject = new CatUnion(skipObjectsList);
        int numSkipObjects = 0;
        while (skipObject.hasNext()) {
            skipObject.next();
            ++numSkipObjects;
        }
        int numCommonObjects = 0;
        ArrayList<Iterator<CatElement>> commonObjectsList = new ArrayList<Iterator<CatElement>>();
        hmIterator1 = dictionary1.getAllObjects().entrySet().iterator();
        Iterator hmIterator2 = dictionary2.getAllObjects().entrySet().iterator();
        boolean skip1 = false;
        boolean skip2 = false;
        String dataType1 = "";
        String dataType2 = "";
        DictionarySection section1 = null;
        DictionarySection section2 = null;
        while (hmIterator1.hasNext() || hmIterator2.hasNext()) {
            if (hmIterator1.hasNext() && !skip1) {
                Map.Entry entry1 = hmIterator1.next();
                section1 = (DictionarySection)entry1.getValue();
                dataType1 = (String)entry1.getKey();
            }
            if (hmIterator2.hasNext() && !skip2) {
                Map.Entry entry2 = hmIterator2.next();
                section2 = (DictionarySection)entry2.getValue();
                dataType2 = (String)entry2.getKey();
            }
            if (section1 != null && section2 != null && dataType1.equals(dataType2)) {
                commonObjectsList.add(new CatIntersection(new CatWrapper(section1.getSortedEntries(), dataType1 + "_1"), new CatWrapper(section2.getSortedEntries(), dataType2 + "_2")));
                continue;
            }
            if (dataType1.compareTo(dataType2) > 0) {
                skip1 = true;
                skip2 = false;
            } else if (dataType1.compareTo(dataType2) < 0) {
                skip1 = false;
                skip2 = true;
            }
            if (!hmIterator2.hasNext()) {
                skip1 = false;
            }
            if (hmIterator1.hasNext()) continue;
            skip2 = false;
        }
        CatUnion commonO1O2 = new CatUnion(commonObjectsList);
        while (commonO1O2.hasNext()) {
            commonO1O2.next();
            ++numCommonObjects;
        }
        skipObjectsList = new ArrayList();
        if (dictionary1.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2")));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1"), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2")));
        }
        if (dictionary2.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2"), new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1")));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2"), new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1")));
        }
        skipObject = new CatUnion(skipObjectsList);
        long numObject = dictionary1.getNAllObjects() + dictionary2.getNAllObjects() - (long)numCommonObjects - (long)numSkipObjects;
        hmIterator1 = dictionary1.getAllObjects().entrySet().iterator();
        hmIterator2 = dictionary2.getAllObjects().entrySet().iterator();
        int type = 4;
        ArrayList<String> dataTypes = new ArrayList<String>();
        countSubSections1 = 0;
        countSubSections2 = 0;
        HashMap<String, Long> offsets = new HashMap<String, Long>();
        long total = 0L;
        skip1 = false;
        skip2 = false;
        dataType1 = "";
        dataType2 = "";
        section1 = null;
        section2 = null;
        Object prefix1 = "";
        Object prefix2 = "";
        while (hmIterator1.hasNext() || hmIterator2.hasNext()) {
            Map.Entry entry;
            ArrayList<Iterator<CatElement>> addObjectsList = new ArrayList<Iterator<CatElement>>();
            ArrayList<Iterator<CatElement>> countObjectsList = new ArrayList<Iterator<CatElement>>();
            if (hmIterator1.hasNext() && !skip1) {
                entry = hmIterator1.next();
                dataType1 = (String)entry.getKey();
                section1 = (DictionarySection)entry.getValue();
                prefix1 = "sub" + countSubSections1;
                if (dataType1.equals(NO_DT_OBJECTS)) {
                    prefix1 = dataType1;
                }
                ++countSubSections1;
            }
            if (hmIterator2.hasNext() && !skip2) {
                entry = hmIterator2.next();
                dataType2 = (String)entry.getKey();
                section2 = (DictionarySection)entry.getValue();
                prefix2 = "sub" + countSubSections2;
                if (dataType2.equals(NO_DT_OBJECTS)) {
                    prefix2 = dataType2;
                }
                ++countSubSections2;
            }
            String dataType3 = "";
            if (section1 != null && section2 != null && dataType1.equals(dataType2)) {
                dataType3 = dataType1;
                addObjectsList.add(new CatWrapper(section1.getSortedEntries(), (String)prefix1 + "1"));
                countObjectsList.add(new CatWrapper(section1.getSortedEntries(), (String)prefix1 + "1"));
                addObjectsList.add(new CatWrapper(section2.getSortedEntries(), (String)prefix2 + "2"));
                countObjectsList.add(new CatWrapper(section2.getSortedEntries(), (String)prefix2 + "2"));
                skip1 = false;
                skip2 = false;
                if (!hmIterator1.hasNext()) {
                    section1 = null;
                    dataType1 = "";
                } else if (!hmIterator2.hasNext()) {
                    section2 = null;
                    dataType2 = "";
                }
            } else {
                boolean fromOne = false;
                boolean fromTwo = false;
                if (dataType1.equals("")) {
                    fromTwo = true;
                } else if (dataType2.equals("")) {
                    fromOne = true;
                }
                if (dataType1.compareTo(dataType2) < 0) {
                    fromOne = true;
                }
                if (dataType1.compareTo(dataType2) > 0) {
                    fromTwo = true;
                }
                if (section1 != null && fromOne) {
                    dataType3 = dataType1;
                    addObjectsList.add(new CatWrapper(section1.getSortedEntries(), (String)prefix1 + "1"));
                    countObjectsList.add(new CatWrapper(section1.getSortedEntries(), (String)prefix1 + "1"));
                    if (!hmIterator1.hasNext()) {
                        section1 = null;
                        dataType1 = "";
                        skip2 = false;
                    } else {
                        skip1 = false;
                        skip2 = true;
                    }
                } else if (section2 != null && fromTwo) {
                    dataType3 = dataType2;
                    addObjectsList.add(new CatWrapper(section2.getSortedEntries(), (String)prefix2 + "2"));
                    countObjectsList.add(new CatWrapper(section2.getSortedEntries(), (String)prefix2 + "2"));
                    if (!hmIterator2.hasNext()) {
                        section2 = null;
                        dataType2 = "";
                        skip1 = false;
                    } else {
                        skip1 = true;
                        skip2 = false;
                    }
                }
            }
            long numberElts = 0L;
            CatUnion itCountObjects = new CatUnion(countObjectsList);
            while (itCountObjects.hasNext()) {
                ++numberElts;
                itCountObjects.next();
            }
            CatUnion itAddObjects = new CatUnion(addObjectsList);
            if (dataType3.equals(NO_DT_OBJECTS)) {
                this.catSection(numberElts -= (long)numSkipObjects, type, itAddObjects, skipObject, this.allMappings, listener);
            } else {
                this.catSection(numberElts, type, itAddObjects, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, listener);
            }
            if (numberElts > 0L) {
                dataTypes.add(dataType3);
                offsets.put(dataType3, total);
            }
            total += numberElts;
            ++type;
        }
        System.out.println("SHARED-------------------");
        int numCommonS1O2 = 0;
        if (dictionary2.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            CatIntersection i23 = new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2"));
            while (i23.hasNext()) {
                i23.next();
                ++numCommonS1O2;
            }
        }
        int numCommonO1S2 = 0;
        if (dictionary1.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            i22 = new CatIntersection(new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1"), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"));
            while (i22.hasNext()) {
                i22.next();
                ++numCommonO1S2;
            }
        }
        i22 = new CatIntersection(new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2"));
        int numCommonSh1Sh2 = 0;
        while (i22.hasNext()) {
            i22.next();
            ++numCommonSh1Sh2;
        }
        this.numShared = dictionary1.getShared().getNumberOfElements() + dictionary2.getShared().getNumberOfElements() - (long)numCommonSh1Sh2 + (long)numCommonS1O2 + (long)numCommonO1S2;
        ArrayList<Iterator<CatElement>> addSharedList = new ArrayList<Iterator<CatElement>>();
        addSharedList.add(new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1"));
        addSharedList.add(new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2"));
        if (dictionary1.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            addSharedList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2")));
            addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"), new CatWrapper(((DictionarySection)dictionary1.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE1")));
        }
        if (dictionary2.getAllObjects().containsKey(NO_DT_OBJECTS)) {
            addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2")));
            addSharedList.add(new CatIntersection(new CatWrapper(((DictionarySection)dictionary2.getAllObjects().get(NO_DT_OBJECTS)).getSortedEntries(), "NO_DATATYPE2"), new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1")));
        }
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), "S1"), new CatWrapper(dictionary2.getShared().getSortedEntries(), "SH2")));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), "S2"), new CatWrapper(dictionary1.getShared().getSortedEntries(), "SH1")));
        CatUnion itAddShared = new CatUnion(addSharedList);
        this.catSection(this.numShared, 1, itAddShared, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, listener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat("<http://purl.org/HDT/hdt#dictionaryFour>");
        ci.setInt("elements", numSubjects + numPredicates + numObject + this.numShared);
        try {
            ci.save(new FileOutputStream(this.location + "dictionary"));
            FileOutputStream outFinal = new FileOutputStream(this.location + "dictionary", true);
            byte[] buf = new byte[100000];
            for (i2 = 1; i2 <= 3 + dataTypes.size(); ++i2) {
                try {
                    int b;
                    if (i2 == 4) {
                        outFinal.write(dataTypes.size());
                        for (String datatype : dataTypes) {
                            outFinal.write(datatype.length());
                            IOUtil.writeBuffer(outFinal, datatype.getBytes(), 0, datatype.getBytes().length, listener);
                        }
                    }
                    FileInputStream in = new FileInputStream(this.location + "section" + i2);
                    while ((b = ((InputStream)in).read(buf)) >= 0) {
                        outFinal.write(buf, 0, b);
                        outFinal.flush();
                    }
                    ((InputStream)in).close();
                    Files.delete(Paths.get(this.location + "section" + i2, new String[0]));
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            outFinal.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long oldId = 0L;
        hmIterator1 = dictionary1.getAllObjects().entrySet().iterator();
        countSubSections1 = 0;
        countSubSections2 = 0;
        while (hmIterator1.hasNext()) {
            Map.Entry entry = hmIterator1.next();
            dataType = (String)entry.getKey();
            String prefix = "sub" + countSubSections1;
            prefix = dataType.equals(NO_DT_OBJECTS) ? dataType + "1" : prefix + "1";
            if (this.allMappings.containsKey(prefix)) {
                mapping = this.allMappings.get(prefix);
                i = 0;
                while ((long)i < mapping.getSize()) {
                    newId = mapping.getMapping(i);
                    if (mapping.getType(i) != 1L && offsets.containsKey(dataType)) {
                        newId += ((Long)offsets.get(dataType)).longValue();
                    }
                    this.allMappings.get("O1").set(oldId, newId, (int)mapping.getType(i));
                    ++oldId;
                    ++i;
                }
            }
            ++countSubSections1;
        }
        oldId = 0L;
        for (Map.Entry entry : dictionary2.getAllObjects().entrySet()) {
            dataType = (String)entry.getKey();
            String prefix = "sub" + countSubSections2;
            prefix = dataType.equals(NO_DT_OBJECTS) ? dataType + "2" : prefix + "2";
            if (!this.allMappings.containsKey(prefix)) continue;
            mapping = this.allMappings.get(prefix);
            ++countSubSections2;
            i = 0;
            while ((long)i < mapping.getSize()) {
                newId = mapping.getMapping(i);
                if (mapping.getType(i) != 1L && offsets.containsKey(dataType)) {
                    newId += ((Long)offsets.get(dataType)).longValue();
                }
                this.allMappings.get("O2").set(oldId, newId, (int)mapping.getType(i));
                ++oldId;
                ++i;
            }
        }
        this.mappingS = new CatMappingBack(this.location, numSubjects + this.numShared);
        i2 = 0;
        while ((long)i2 < this.allMappings.get("SH1").getSize()) {
            this.mappingS.set(this.allMappings.get("SH1").getMapping(i2), i2 + 1, 1);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < this.allMappings.get("SH2").getSize()) {
            this.mappingS.set(this.allMappings.get("SH2").getMapping(i2), i2 + 1, 2);
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < this.allMappings.get("S1").getSize()) {
            if (this.allMappings.get("S1").getType(i2) == 1L) {
                this.mappingS.set(this.allMappings.get("S1").getMapping(i2), i2 + 1 + (int)dictionary1.getNshared(), 1);
            } else {
                this.mappingS.set(this.allMappings.get("S1").getMapping(i2) + (long)((int)this.numShared), i2 + 1 + (int)dictionary1.getNshared(), 1);
            }
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < this.allMappings.get("S2").getSize()) {
            if (this.allMappings.get("S2").getType(i2) == 1L) {
                this.mappingS.set(this.allMappings.get("S2").getMapping(i2), i2 + 1 + (int)dictionary2.getNshared(), 2);
            } else {
                this.mappingS.set(this.allMappings.get("S2").getMapping(i2) + (long)((int)this.numShared), i2 + 1 + (int)dictionary2.getNshared(), 2);
            }
            ++i2;
        }
    }

    private void catSection(long numEntries, int type, CatUnion itAdd, CatUnion itSkip, HashMap<String, CatMapping> mappings, ProgressListener listener) throws IOException {
        ByteArrayOutputStream byteOut;
        SequenceLog64BigDisk blocks;
        String name;
        long numberElements = 0L;
        switch (type) {
            case 2: {
                name = "subject";
                break;
            }
            case 3: {
                name = "object";
                break;
            }
            case 4: {
                name = "predicate";
                break;
            }
            default: {
                name = "";
            }
        }
        long storedBuffersSize = 0L;
        long numBlocks = 0L;
        try (CRCOutputStream outBuffer = new CRCOutputStream(new FileOutputStream(this.location + "section_buffer_" + type), new CRC32());){
            blocks = new SequenceLog64BigDisk(this.location + "SequenceLog64BigDisk" + type, 64, numEntries / 16L);
            byteOut = new ByteArrayOutputStream(16384);
            if (numEntries > 0L) {
                String previousStr = null;
                CatElement skipElement = null;
                if (itSkip.hasNext()) {
                    skipElement = itSkip.next();
                }
                while (itAdd.hasNext()) {
                    ListenerUtil.notifyCond(listener, "Analyze section " + name + " ", numberElements, numberElements, numEntries);
                    CatElement nextElement = itAdd.next();
                    if (skipElement != null && nextElement.entity.toString().equals(skipElement.entity.toString())) {
                        if (itSkip.hasNext()) {
                            skipElement = itSkip.next();
                            continue;
                        }
                        skipElement = null;
                        continue;
                    }
                    for (int i = 0; i < nextElement.IDs.size(); ++i) {
                        long id = nextElement.IDs.get((int)i).pos;
                        String iter = nextElement.IDs.get((int)i).iter.toString();
                        mappings.get(iter).set(id - 1L, numberElements + 1L, type);
                    }
                    String str = nextElement.entity.toString();
                    if (numberElements % 16L == 0L) {
                        blocks.append(storedBuffersSize + (long)byteOut.size());
                        if ((++numBlocks - 1L) % 1000000L == 0L && (numBlocks - 1L) / 1000000L != 0L || byteOut.size() > 200000) {
                            storedBuffersSize += (long)byteOut.size();
                            byteOut.flush();
                            byte[] array = byteOut.toByteArray();
                            IOUtil.writeBuffer(outBuffer, array, 0, array.length, null);
                            byteOut.close();
                            byteOut = new ByteArrayOutputStream(16384);
                        }
                        ByteStringUtil.append(byteOut, str, 0);
                    } else {
                        int delta = ByteStringUtil.longestCommonPrefix(previousStr, str);
                        VByte.encode(byteOut, delta);
                        ByteStringUtil.append(byteOut, str, delta);
                    }
                    byteOut.write(0);
                    previousStr = str;
                    ++numberElements;
                }
            }
            blocks.append(storedBuffersSize + (long)byteOut.size());
            blocks.aggressiveTrimToSize();
            byteOut.flush();
            IOUtil.writeBuffer(outBuffer, byteOut.toByteArray(), 0, byteOut.toByteArray().length, null);
            outBuffer.writeCRC();
        }
        try (CRCOutputStream out = new CRCOutputStream(new FileOutputStream(this.location + "section" + type), new CRC8());){
            int b;
            out.write(2);
            VByte.encode(out, numberElements);
            VByte.encode(out, storedBuffersSize + (long)byteOut.size());
            VByte.encode(out, 16L);
            out.writeCRC();
            blocks.save(out, null);
            blocks.close();
            byte[] buf = new byte[100000];
            FileInputStream in = new FileInputStream(this.location + "section_buffer_" + type);
            while ((b = ((InputStream)in).read(buf)) >= 0) {
                out.write(buf, 0, b);
                out.flush();
            }
        }
        Files.deleteIfExists(Paths.get(this.location + "section_buffer_" + type, new String[0]));
        Files.deleteIfExists(Paths.get(this.location + "SequenceLog64BigDisk" + type, new String[0]));
    }

    @Override
    public CatMappingBack getMappingS() {
        return this.mappingS;
    }

    @Override
    public HashMap<String, CatMapping> getAllMappings() {
        return this.allMappings;
    }

    @Override
    public long getNumShared() {
        return this.numShared;
    }
}

