/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.PSFCTempDictionary;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.DelayedString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class PSFCFourSectionDictionary
extends FourSectionDictionary {
    public PSFCFourSectionDictionary(HDTOptions spec) {
        super(spec);
    }

    static CharSequence encode(CharSequence str) {
        CharSequence s = DelayedString.unwrap(str);
        if (s == null || s.length() == 0 || s.charAt(0) != '\"' || s.charAt(s.length() - 1) == '\"') {
            return str;
        }
        if (s instanceof CompactString) {
            CompactString cs = (CompactString)s;
            return PSFCFourSectionDictionary.swap(cs, cs.lastIndexOf('\"') + 1);
        }
        String string = s.toString();
        return PSFCFourSectionDictionary.swap(string, string.lastIndexOf(34) + 1);
    }

    static CharSequence decode(CharSequence str) {
        char ch;
        CharSequence s = DelayedString.unwrap(str);
        if (s == null || s.length() == 0 || (ch = s.charAt(0)) != '^' && ch != '@' || s.charAt(s.length() - 1) != '\"') {
            return str;
        }
        if (s instanceof CompactString) {
            CompactString cs = (CompactString)s;
            return PSFCFourSectionDictionary.swap(cs, cs.indexOf('\"'));
        }
        String string = s.toString();
        return PSFCFourSectionDictionary.swap(string, string.indexOf(34));
    }

    @Override
    public long stringToId(CharSequence str, TripleComponentRole position) {
        return super.stringToId(PSFCFourSectionDictionary.encode(str), position);
    }

    @Override
    public CharSequence idToString(long id, TripleComponentRole position) {
        return PSFCFourSectionDictionary.decode(super.idToString(id, position));
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#dictionaryFourPsfc>";
    }

    @Override
    public void load(TempDictionary other, ProgressListener listener) {
        if (!(other instanceof PSFCTempDictionary)) {
            throw new IllegalArgumentException("Expected " + PSFCTempDictionary.class.getName());
        }
        super.load(other, listener);
    }

    private static CharSequence swap(CompactString cs, int offset) {
        ReplazableString buf = new ReplazableString(cs.length());
        buf.append(cs.getData(), offset, cs.length() - offset);
        buf.append(cs.getData(), 0, offset);
        return new CompactString(buf).getDelayed();
    }

    private static String swap(String string, int offset) {
        StringBuilder buf = new StringBuilder(string.length());
        buf.append(string, offset, string.length());
        buf.append(string, 0, offset);
        return buf.toString();
    }
}

