/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Big;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.Mutable;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.BigByteBuffer;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PFCDictionarySectionBig
implements DictionarySectionPrivate {
    private static final Logger log = LoggerFactory.getLogger(PFCDictionarySectionBig.class);
    public static final int TYPE_INDEX = 2;
    public static final int DEFAULT_BLOCK_SIZE = 16;
    public static final int BLOCK_PER_BUFFER = 1000000;
    BigByteBuffer[] data;
    long[] posFirst;
    protected SequenceLog64Big blocks;
    protected int blocksize;
    protected long numstrings;
    protected long size;
    static int filecounter = 0;

    public PFCDictionarySectionBig(HDTOptions spec) {
        this.blocksize = (int)spec.getInt("pfc.blocksize");
        if (this.blocksize == 0) {
            this.blocksize = 16;
        }
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        this.blocks = new SequenceLog64Big(BitUtil.log2(other.size()), other.getNumberOfElements() / (long)this.blocksize);
        log.info("numbits:{}", (Object)BitUtil.log2(other.size()));
        Iterator it = other.getSortedEntries();
        this.load(it, other.getNumberOfElements(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Iterator<? extends CharSequence> it, long numentries, ProgressListener listener) {
        FileOutputStream out;
        File file;
        this.blocks = new SequenceLog64Big(64, numentries / (long)this.blocksize);
        this.numstrings = 0L;
        ++filecounter;
        try {
            file = File.createTempFile("test", ".tmp");
            out = new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temporary file.", e);
        }
        long byteoutsize = 0L;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(16384);
        CharSequence previousStr = null;
        try {
            while (it.hasNext()) {
                CharSequence str = it.next();
                if (this.numstrings % (long)this.blocksize == 0L) {
                    byteOut.flush();
                    this.blocks.append(byteoutsize += (long)byteOut.size());
                    byteOut.writeTo(out);
                    byteOut.reset();
                    ByteStringUtil.append(byteOut, str, 0);
                } else {
                    int delta = ByteStringUtil.longestCommonPrefix(previousStr, str);
                    VByte.encode(byteOut, delta);
                    ByteStringUtil.append(byteOut, str, delta);
                }
                byteOut.write(0);
                ++this.numstrings;
                previousStr = str;
            }
            byteOut.flush();
            this.blocks.append(byteoutsize += (long)byteOut.size());
            this.blocks.aggressiveTrimToSize();
            byteOut.flush();
            byteOut.writeTo(out);
            out.close();
            FileInputStream in = new FileInputStream(file);
            int block = 0;
            int buffer = 0;
            long bytePos = 0L;
            long numBlocks = this.blocks.getNumberOfElements();
            long numBuffers = numBlocks > 0L ? 1L + numBlocks / 1000000L : 0L;
            this.data = new BigByteBuffer[(int)numBuffers];
            this.posFirst = new long[(int)numBuffers];
            while ((long)block < numBlocks - 1L) {
                long nextBlock = Math.min(numBlocks - 1L, (long)(block + 1000000));
                long nextBytePos = this.blocks.get(nextBlock);
                BigByteBuffer bigByteBuffer = BigByteBuffer.allocate(nextBytePos - bytePos);
                bigByteBuffer.readStream(in, 0L, bigByteBuffer.size(), listener);
                this.data[buffer] = bigByteBuffer;
                this.posFirst[buffer] = bytePos;
                bytePos = nextBytePos;
                block += 1000000;
                ++buffer;
            }
        }
        catch (IOException e) {
            log.error("Unexpected exception.", (Throwable)e);
        }
        finally {
            try {
                out.close();
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                log.error("Unexpected exception.", (Throwable)e);
            }
        }
    }

    protected long locateBlock(CharSequence str) {
        long high;
        long low = 0L;
        long max = high = this.blocks.getNumberOfElements() - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            int cmp = mid == max ? -1 : ByteStringUtil.strcmp(str, this.data[(int)(mid / 1000000L)], this.blocks.get(mid) - this.posFirst[(int)(mid / 1000000L)]);
            if (cmp < 0) {
                high = mid - 1L;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public long locate(CharSequence str) {
        long idblock;
        long blocknum = this.locateBlock(str);
        if (blocknum >= 0L) {
            return blocknum * (long)this.blocksize + 1L;
        }
        if ((blocknum = -blocknum - 2L) >= 0L && (idblock = this.locateInBlock(blocknum, str)) != 0L) {
            return blocknum * (long)this.blocksize + idblock + 1L;
        }
        return 0L;
    }

    protected long locateInBlock(long blocknum, CharSequence str) {
        ReplazableString tempString = new ReplazableString();
        Mutable<Long> delta = new Mutable<Long>(0L);
        long idInBlock = 0L;
        int cshared = 0;
        BigByteBuffer block = this.data[(int)(blocknum / 1000000L)];
        long pos = this.blocks.get(blocknum) - this.posFirst[(int)(blocknum / 1000000L)];
        int slen = (int)ByteStringUtil.strlen(block, pos);
        tempString.append(block, pos, slen);
        pos += (long)(slen + 1);
        ++idInBlock;
        while (idInBlock < (long)this.blocksize && pos < block.size()) {
            pos += (long)VByte.decode(block, pos, delta);
            slen = (int)ByteStringUtil.strlen(block, pos);
            tempString.replace(delta.getValue().intValue(), block, pos, slen);
            if (delta.getValue() < (long)cshared) {
                idInBlock = 0L;
                break;
            }
            if ((cshared += ByteStringUtil.longestCommonPrefix(tempString, str, cshared)) == str.length() && tempString.length() == str.length()) {
                return idInBlock;
            }
            pos += (long)(slen + 1);
            ++idInBlock;
        }
        if (pos == block.size() || idInBlock == (long)this.blocksize) {
            idInBlock = 0L;
        }
        return idInBlock;
    }

    public CharSequence extract(long id) {
        if (id < 1L || id > this.numstrings) {
            return null;
        }
        long blockid = (id - 1L) / (long)this.blocksize;
        long nstring = (id - 1L) % (long)this.blocksize;
        BigByteBuffer block = this.data[(int)(blockid / 1000000L)];
        long pos = this.blocks.get(blockid) - this.posFirst[(int)(blockid / 1000000L)];
        int len = (int)ByteStringUtil.strlen(block, pos);
        Mutable<Long> delta = new Mutable<Long>(0L);
        ReplazableString tempString = new ReplazableString();
        tempString.append(block, pos, len);
        for (long i = 0L; i < nstring; ++i) {
            pos += (long)(len + 1);
            pos += (long)VByte.decode(block, pos, delta);
            len = (int)ByteStringUtil.strlen(block, pos);
            tempString.replace(delta.getValue().intValue(), block, pos, len);
        }
        return new CompactString(tempString).getDelayed();
    }

    public long size() {
        return this.size;
    }

    public long getNumberOfElements() {
        return this.numstrings;
    }

    public Iterator<CharSequence> getSortedEntries() {
        return new Iterator<CharSequence>(){
            long pos;

            @Override
            public boolean hasNext() {
                return this.pos < PFCDictionarySectionBig.this.getNumberOfElements();
            }

            @Override
            public CharSequence next() {
                ++this.pos;
                return PFCDictionarySectionBig.this.extract(this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(2);
        VByte.encode(out, this.numstrings);
        long datasize = 0L;
        for (BigByteBuffer bigByteBuffer : this.data) {
            datasize += bigByteBuffer.size();
        }
        log.info("datasize:{}", (Object)datasize);
        VByte.encode(out, datasize);
        VByte.encode(out, this.blocksize);
        out.writeCRC();
        this.blocks.save(output, listener);
        out.setCRC(new CRC32());
        for (BigByteBuffer datum : this.data) {
            datum.writeStream(out, 0L, datum.size(), listener);
        }
        out.writeCRC();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 2) {
            throw new IllegalFormatException("Trying to read a DictionarySectionPFC from data that is not of the suitable type");
        }
        this.numstrings = VByte.decode(in);
        this.size = VByte.decode(in);
        this.blocksize = (int)VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Header.");
        }
        this.blocks = new SequenceLog64Big();
        this.blocks.load(input, listener);
        in.setCRC(new CRC32());
        int block = 0;
        int buffer = 0;
        long bytePos = 0L;
        long numBlocks = this.blocks.getNumberOfElements();
        long numBuffers = 1L + numBlocks / 1000000L;
        this.data = new BigByteBuffer[(int)numBuffers];
        this.posFirst = new long[(int)numBuffers];
        while ((long)block < numBlocks - 1L) {
            long nextBlock = Math.min(numBlocks - 1L, (long)(block + 1000000));
            long nextBytePos = this.blocks.get(nextBlock);
            BigByteBuffer bigByteBuffer = BigByteBuffer.allocate(nextBytePos - bytePos);
            bigByteBuffer.readStream(in, 0L, bigByteBuffer.size(), listener);
            this.data[buffer] = bigByteBuffer;
            this.posFirst[buffer] = bytePos;
            bytePos = nextBytePos;
            block += 1000000;
            ++buffer;
        }
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Data.");
        }
    }

    public void close() throws IOException {
        this.data = null;
        this.posFirst = null;
        this.blocks.close();
        this.blocks = null;
    }
}

