/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceFactory;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.io.BigMappedByteBuffer;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PFCDictionarySectionMap
implements DictionarySectionPrivate,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(PFCDictionarySectionMap.class);
    static final int BLOCKS_PER_BYTEBUFFER = 50000;
    protected FileChannel ch;
    protected BigMappedByteBuffer[] buffers;
    long[] posFirst;
    protected int blocksize;
    protected long numstrings;
    protected Sequence blocks;
    protected long dataSize;
    private final File f;
    private final long startOffset;
    private final long endOffset;

    public PFCDictionarySectionMap(CountInputStream input, File f) throws IOException {
        this.f = f;
        this.startOffset = input.getTotalBytes();
        CRCInputStream crcin = new CRCInputStream(input, new CRC8());
        int type = crcin.read();
        if (type != 2) {
            throw new IllegalFormatException("Trying to read a DictionarySectionPFC from data that is not of the suitable type");
        }
        this.numstrings = VByte.decode(crcin);
        this.dataSize = VByte.decode(crcin);
        this.blocksize = (int)VByte.decode(crcin);
        if (!crcin.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Dictionary Section Plain Front Coding Header.");
        }
        this.blocks = SequenceFactory.createStream(input, f);
        long base = input.getTotalBytes();
        IOUtil.skip(crcin, this.dataSize + 4L);
        this.endOffset = input.getTotalBytes();
        this.ch = FileChannel.open(Paths.get(f.toString(), new String[0]), new OpenOption[0]);
        long block = 0L;
        int buffer = 0;
        long numBlocks = this.blocks.getNumberOfElements();
        long bytePos = 0L;
        long numBuffers = 1L + numBlocks / 50000L;
        this.buffers = new BigMappedByteBuffer[(int)numBuffers];
        this.posFirst = new long[(int)numBuffers];
        while (block < numBlocks - 1L) {
            long nextBlock = Math.min(numBlocks - 1L, block + 50000L);
            long nextBytePos = this.blocks.get(nextBlock);
            this.buffers[buffer] = BigMappedByteBuffer.ofFileChannel(this.ch, FileChannel.MapMode.READ_ONLY, base + bytePos, nextBytePos - bytePos);
            this.buffers[buffer].order(ByteOrder.LITTLE_ENDIAN);
            this.posFirst[buffer] = bytePos;
            bytePos = nextBytePos;
            block += 50000L;
            ++buffer;
        }
    }

    private long locateBlock(CharSequence str) {
        long high;
        if (this.blocks.getNumberOfElements() == 0L) {
            return -1L;
        }
        long low = 0L;
        long max = high = this.blocks.getNumberOfElements() - 1L;
        while (low <= high) {
            int cmp;
            long mid = low + (high - low) / 2L;
            if (mid == max) {
                cmp = -1;
            } else {
                BigMappedByteBuffer buffer = this.buffers[(int)(mid / 50000L)];
                cmp = ByteStringUtil.strcmp(str, buffer, this.blocks.get(mid) - this.posFirst[(int)(mid / 50000L)]);
            }
            if (cmp < 0) {
                high = mid - 1L;
                continue;
            }
            if (cmp > 0) {
                low = mid + 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public long locate(CharSequence str) {
        long idblock;
        if (this.buffers == null || this.blocks == null) {
            return 0L;
        }
        long blocknum = this.locateBlock(str);
        if (blocknum >= 0L) {
            return blocknum * (long)this.blocksize + 1L;
        }
        if ((blocknum = -blocknum - 2L) >= 0L && (idblock = this.locateInBlock(blocknum, str)) != 0L) {
            return blocknum * (long)this.blocksize + idblock + 1L;
        }
        return 0L;
    }

    protected long locateInBlock(long block, CharSequence str) {
        if (block >= this.blocks.getNumberOfElements()) {
            return 0L;
        }
        ReplazableString tempString = new ReplazableString();
        long idInBlock = 0L;
        int cshared = 0;
        BigMappedByteBuffer buffer = this.buffers[(int)(block / 50000L)].duplicate();
        buffer.position(this.blocks.get(block) - this.posFirst[(int)(block / 50000L)]);
        try {
            if (!buffer.hasRemaining()) {
                return 0L;
            }
            tempString.replace(buffer, 0);
            ++idInBlock;
            while (idInBlock < (long)this.blocksize && buffer.hasRemaining()) {
                long delta = VByte.decode(buffer);
                tempString.replace(buffer, (int)delta);
                if (delta >= (long)cshared) {
                    if ((cshared += ByteStringUtil.longestCommonPrefix(tempString, str, cshared)) == str.length() && tempString.length() == str.length()) {
                        return idInBlock;
                    }
                } else {
                    return 0L;
                }
                ++idInBlock;
            }
            return 0L;
        }
        catch (IOException e) {
            log.error("Unexpected exception.", (Throwable)e);
            return 0L;
        }
    }

    public CharSequence extract(long id) {
        if (this.buffers == null || this.blocks == null) {
            return null;
        }
        if (id < 1L || id > this.numstrings) {
            return null;
        }
        long block = (id - 1L) / (long)this.blocksize;
        BigMappedByteBuffer buffer = this.buffers[(int)(block / 50000L)].duplicate();
        buffer.position(this.blocks.get(block) - this.posFirst[(int)(block / 50000L)]);
        try {
            ReplazableString tempString = new ReplazableString();
            tempString.replace(buffer, 0);
            long stringid = (id - 1L) % (long)this.blocksize;
            for (long i = 0L; i < stringid; ++i) {
                long delta = VByte.decode(buffer);
                tempString.replace(buffer, (int)delta);
            }
            return new CompactString(tempString).getDelayed();
        }
        catch (IOException e) {
            log.error("Unexpected exception.", (Throwable)e);
            return null;
        }
    }

    public long size() {
        return this.dataSize + this.blocks.size();
    }

    public long getNumberOfElements() {
        return this.numstrings;
    }

    public Iterator<CharSequence> getSortedEntries() {
        if (this.buffers[0] == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<CharSequence>(){
            long id = 0L;
            final ReplazableString tempString = new ReplazableString();
            int bytebufferIndex;
            BigMappedByteBuffer buffer;
            {
                this.buffer = PFCDictionarySectionMap.this.buffers[0].duplicate();
            }

            @Override
            public boolean hasNext() {
                return this.id < PFCDictionarySectionMap.this.getNumberOfElements();
            }

            @Override
            public CharSequence next() {
                if (!this.buffer.hasRemaining()) {
                    this.buffer = PFCDictionarySectionMap.this.buffers[++this.bytebufferIndex].duplicate();
                    this.buffer.rewind();
                }
                try {
                    if (this.id % (long)PFCDictionarySectionMap.this.blocksize == 0L) {
                        this.tempString.replace(this.buffer, 0);
                    } else {
                        long delta = VByte.decode(this.buffer);
                        this.tempString.replace(this.buffer, (int)delta);
                    }
                    ++this.id;
                    return new CompactString(this.tempString).getDelayed();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.blocks.close();
        this.buffers = null;
        this.ch.close();
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.f));
        IOUtil.skip(in, this.startOffset);
        IOUtil.copyStream(in, output, this.endOffset - this.startOffset);
        ((InputStream)in).close();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }
}

