/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.writer;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.impl.HDTImpl;
import org.rdfhdt.hdt.hdt.impl.ModeOfLoading;
import org.rdfhdt.hdt.hdt.impl.TempHDTImpl;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.header.HeaderUtil;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.TripleWriter;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.StopWatch;

public class TripleWriterHDT
implements TripleWriter {
    private OutputStream out;
    private boolean close = false;
    HDTOptions spec;
    String baseUri;
    StopWatch st = new StopWatch();
    TempHDT modHDT;
    TempDictionary dictionary;
    TempTriples triples;
    long num = 0L;
    long size = 0L;

    public TripleWriterHDT(String baseUri, HDTOptions spec, String outFile, boolean compress) throws IOException {
        this.baseUri = baseUri;
        this.spec = spec;
        this.out = compress ? new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)))) : new BufferedOutputStream(new FileOutputStream(outFile));
        this.close = true;
        this.init();
    }

    public TripleWriterHDT(String baseUri, HDTOptions spec, OutputStream out) {
        this.baseUri = baseUri;
        this.spec = spec;
        this.out = new BufferedOutputStream(out);
        this.init();
    }

    private void init() {
        this.modHDT = new TempHDTImpl(this.spec, this.baseUri, ModeOfLoading.ONE_PASS);
        this.dictionary = this.modHDT.getDictionary();
        this.triples = this.modHDT.getTriples();
        this.dictionary.startProcessing();
    }

    public void addTriple(TripleString triple) throws IOException {
        this.triples.insert(this.dictionary.insert(triple.getSubject(), TripleComponentRole.SUBJECT), this.dictionary.insert(triple.getPredicate(), TripleComponentRole.PREDICATE), this.dictionary.insert(triple.getObject(), TripleComponentRole.OBJECT));
        ++this.num;
        this.size += (long)(triple.getSubject().length() + triple.getPredicate().length() + triple.getObject().length() + 4);
    }

    public void close() throws IOException {
        ProgressListener listener = null;
        this.dictionary.endProcessing();
        this.modHDT.reorganizeDictionary(listener);
        this.modHDT.reorganizeTriples(listener);
        this.modHDT.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", this.size);
        HDTImpl hdt = new HDTImpl(this.spec);
        hdt.loadFromModifiableHDT(this.modHDT, listener);
        hdt.populateHeaderStructure(this.modHDT.getBaseURI());
        try {
            long originalSize = HeaderUtil.getPropertyLong((Header)this.modHDT.getHeader(), (String)"_:statistics", (String)"<http://purl.org/HDT/hdt#originalSize>");
            hdt.getHeader().insert((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", originalSize);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.modHDT.close();
        hdt.saveToHDT(this.out, listener);
        hdt.close();
        if (this.close) {
            this.out.close();
        } else {
            this.out.flush();
        }
    }
}

