/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.header;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.header.HeaderUtil;
import org.rdfhdt.hdt.header.PlainHeaderIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.RDFParserSimple;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainHeader
implements HeaderPrivate,
RDFParserCallback.RDFCallback {
    private static final Logger log = LoggerFactory.getLogger(PlainHeader.class);
    protected final HDTOptions spec;
    protected final List<TripleString> triples = new ArrayList<TripleString>();

    public PlainHeader() {
        this.spec = new HDTSpecification();
    }

    public PlainHeader(HDTOptions spec) {
        this.spec = spec;
    }

    public void insert(CharSequence subject, CharSequence predicate, CharSequence object) {
        String objStr = object.toString();
        if (objStr.charAt(0) == '<' || objStr.charAt(0) == '\"' || objStr.startsWith("http://") || objStr.startsWith("file://")) {
            this.triples.add(new TripleString((CharSequence)HeaderUtil.cleanURI((CharSequence)subject), (CharSequence)HeaderUtil.cleanURI((CharSequence)predicate), object));
        } else {
            this.triples.add(new TripleString((CharSequence)HeaderUtil.cleanURI((CharSequence)subject), (CharSequence)HeaderUtil.cleanURI((CharSequence)predicate), (CharSequence)("\"" + objStr + "\"")));
        }
    }

    public void insert(CharSequence subject, CharSequence predicate, long object) {
        this.triples.add(new TripleString((CharSequence)HeaderUtil.cleanURI((CharSequence)subject), (CharSequence)HeaderUtil.cleanURI((CharSequence)predicate), (CharSequence)("\"" + Long.toString(object) + "\"")));
    }

    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ByteArrayOutputStream headerData = new ByteArrayOutputStream();
        IteratorTripleString iterator = this.search("", "", "");
        while (iterator.hasNext()) {
            TripleString next = (TripleString)iterator.next();
            IOUtil.writeString(headerData, next.asNtriple().toString());
        }
        ci.clear();
        ci.setType(ControlInfo.Type.HEADER);
        ci.setFormat("ntriples");
        ci.setInt("length", (long)headerData.size());
        ci.save(output);
        output.write(headerData.toByteArray());
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        String format = ci.getFormat();
        if (!format.equals("ntriples")) {
            throw new IllegalArgumentException("Cannot parse this Header Format");
        }
        long headerSize = ci.getInt("length");
        byte[] headerData = IOUtil.readBuffer(input, (int)headerSize, listener);
        try {
            RDFParserSimple parser = new RDFParserSimple();
            parser.doParse(new ByteArrayInputStream(headerData), "http://www.rdfhdt.org", RDFNotation.NTRIPLES, true, (RDFParserCallback.RDFCallback)this);
        }
        catch (ParserException e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new IllegalFormatException("Error parsing header");
        }
    }

    public int getNumberOfElements() {
        return this.triples.size();
    }

    public IteratorTripleString search(CharSequence subject, CharSequence predicate, CharSequence object) {
        TripleString pattern = new TripleString((CharSequence)subject.toString(), (CharSequence)predicate.toString(), (CharSequence)object.toString());
        return new PlainHeaderIterator(this, pattern);
    }

    public void processTriple(TripleString triple, long pos) {
        this.triples.add(new TripleString(triple));
    }

    public void remove(CharSequence subject, CharSequence predicate, CharSequence object) {
        TripleString pattern = new TripleString((CharSequence)subject.toString(), (CharSequence)predicate.toString(), (CharSequence)object.toString());
        Iterator<TripleString> iter = this.triples.iterator();
        while (iter.hasNext()) {
            TripleString next = iter.next();
            if (!next.match(pattern)) continue;
            iter.remove();
        }
    }

    public CharSequence getBaseURI() {
        IteratorTripleString it = this.search("", HeaderUtil.cleanURI((CharSequence)"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>"), HeaderUtil.cleanURI((CharSequence)"<http://purl.org/HDT/hdt#Dataset>"));
        if (it.hasNext()) {
            TripleString ts = (TripleString)it.next();
            return ts.getSubject();
        }
        return "";
    }
}

