/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf;

import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.RDFParserList;
import org.rdfhdt.hdt.rdf.parsers.RDFParserRAR;
import org.rdfhdt.hdt.rdf.parsers.RDFParserRIOT;
import org.rdfhdt.hdt.rdf.parsers.RDFParserTar;
import org.rdfhdt.hdt.rdf.parsers.RDFParserZip;

public class RDFParserFactory {
    public static RDFParserCallback getParserCallback(RDFNotation notation) {
        switch (notation) {
            case NTRIPLES: 
            case NQUAD: 
            case TURTLE: 
            case N3: 
            case RDFXML: {
                return new RDFParserRIOT();
            }
            case DIR: {
                throw new NotImplementedException("RDFParserDir not implemented");
            }
            case LIST: {
                return new RDFParserList();
            }
            case ZIP: {
                return new RDFParserZip();
            }
            case TAR: {
                return new RDFParserTar();
            }
            case RAR: {
                return new RDFParserRAR();
            }
            case JSONLD: {
                throw new NotImplementedException("RDFParserJSONLD not implemented");
            }
        }
        throw new NotImplementedException("Parser not found for notation: " + notation);
    }
}

