/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.JenaNodeFormatter;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserRIOT
implements RDFParserCallback,
StreamRDF {
    private static final Logger log = LoggerFactory.getLogger(RDFParserRIOT.class);
    private RDFParserCallback.RDFCallback callback;
    private TripleString triple = new TripleString();

    private void parse(InputStream stream, String baseUri, Lang lang, boolean keepBNode) {
        if (keepBNode) {
            RDFParser.source((InputStream)stream).base(baseUri).lang(lang).labelToNode(LabelToNode.createUseLabelAsGiven()).parse((StreamRDF)this);
        } else {
            RDFParser.source((InputStream)stream).base(baseUri).lang(lang).parse((StreamRDF)this);
        }
    }

    public void doParse(String fileName, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try (InputStream input = IOUtil.getFileInputStream(fileName);){
            this.doParse(input, baseUri, notation, keepBNode, callback);
        }
        catch (FileNotFoundException e) {
            throw new ParserException((Throwable)e);
        }
        catch (Exception e) {
            log.error("Unexpected exception parsing file: {}", (Object)fileName, (Object)e);
            throw new ParserException((Throwable)e);
        }
    }

    public void doParse(InputStream input, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        this.callback = callback;
        try {
            switch (notation) {
                case NTRIPLES: {
                    this.parse(input, baseUri, Lang.NTRIPLES, keepBNode);
                    break;
                }
                case NQUAD: {
                    this.parse(input, baseUri, Lang.NQUADS, keepBNode);
                    break;
                }
                case RDFXML: {
                    this.parse(input, baseUri, Lang.RDFXML, keepBNode);
                    break;
                }
                case N3: 
                case TURTLE: {
                    this.parse(input, baseUri, Lang.TURTLE, keepBNode);
                    break;
                }
                default: {
                    throw new NotImplementedException("Parser not found for format " + notation);
                }
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new ParserException((Throwable)e);
        }
    }

    public void start() {
    }

    public void triple(Triple parsedTriple) {
        this.triple.setAll((CharSequence)JenaNodeFormatter.format(parsedTriple.getSubject()), (CharSequence)JenaNodeFormatter.format(parsedTriple.getPredicate()), (CharSequence)JenaNodeFormatter.format(parsedTriple.getObject()));
        this.callback.processTriple(this.triple, 0L);
    }

    public void quad(Quad quad) {
        this.triple.setAll((CharSequence)JenaNodeFormatter.format(quad.getSubject()), (CharSequence)JenaNodeFormatter.format(quad.getPredicate()), (CharSequence)JenaNodeFormatter.format(quad.getObject()));
        this.callback.processTriple(this.triple, 0L);
    }

    public void base(String base) {
    }

    public void prefix(String prefix, String iri) {
    }

    public void finish() {
    }
}

