/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.iterator.SuppliableIteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;

public class BitmapTriplesIterator
implements SuppliableIteratorTripleID {
    private final BitmapTriples triples;
    private final TripleID pattern;
    private final TripleID returnTriple;
    private long lastPosition;
    private long patX;
    private long patY;
    private long patZ;
    private AdjacencyList adjY;
    private AdjacencyList adjZ;
    long posY;
    long posZ;
    long minY;
    long minZ;
    long maxY;
    long maxZ;
    private long nextY;
    private long nextZ;
    private long x;
    private long y;
    private long z;

    public BitmapTriplesIterator(BitmapTriples triples, TripleID pattern) {
        this.triples = triples;
        this.returnTriple = new TripleID();
        this.pattern = new TripleID();
        this.newSearch(pattern);
    }

    public BitmapTriplesIterator(BitmapTriples triples, long minZ, long maxZ) {
        this.triples = triples;
        this.returnTriple = new TripleID();
        this.pattern = new TripleID();
        this.adjY = triples.adjY;
        this.adjZ = triples.adjZ;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.minY = this.adjZ.findListIndex(minZ);
        this.maxY = this.adjZ.findListIndex(maxZ);
        this.goToStart();
    }

    public void newSearch(TripleID pattern) {
        this.pattern.assign(pattern);
        TripleOrderConvert.swapComponentOrder(this.pattern, TripleComponentOrder.SPO, this.triples.order);
        this.patX = this.pattern.getSubject();
        this.patY = this.pattern.getPredicate();
        this.patZ = this.pattern.getObject();
        this.adjY = this.triples.adjY;
        this.adjZ = this.triples.adjZ;
        this.findRange();
        this.goToStart();
    }

    private void updateOutput() {
        this.lastPosition = this.posZ;
        this.returnTriple.setAll(this.x, this.y, this.z);
        TripleOrderConvert.swapComponentOrder(this.returnTriple, this.triples.order, TripleComponentOrder.SPO);
    }

    private void findRange() {
        if (this.patX != 0L) {
            if (this.patY != 0L) {
                this.minY = this.adjY.find(this.patX - 1L, this.patY);
                if (this.minY == -1L) {
                    this.maxZ = 0L;
                    this.maxY = 0L;
                    this.minZ = 0L;
                    this.minY = 0L;
                } else {
                    this.maxY = this.minY + 1L;
                    if (this.patZ != 0L) {
                        this.minZ = this.adjZ.find(this.minY, this.patZ);
                        if (this.minZ == -1L) {
                            this.maxZ = 0L;
                            this.maxY = 0L;
                            this.minZ = 0L;
                            this.minY = 0L;
                        } else {
                            this.maxZ = this.minZ + 1L;
                        }
                    } else {
                        this.minZ = this.adjZ.find(this.minY);
                        this.maxZ = this.adjZ.last(this.minY) + 1L;
                    }
                }
            } else {
                this.minY = this.adjY.find(this.patX - 1L);
                this.minZ = this.adjZ.find(this.minY);
                this.maxY = this.adjY.last(this.patX - 1L) + 1L;
                this.maxZ = this.adjZ.find(this.maxY);
            }
            this.x = this.patX;
        } else {
            this.minY = 0L;
            this.minZ = 0L;
            this.maxY = this.adjY.getNumberOfElements();
            this.maxZ = this.adjZ.getNumberOfElements();
        }
    }

    public boolean hasNext() {
        return this.posZ < this.maxZ;
    }

    public TripleID next() {
        this.z = this.adjZ.get(this.posZ);
        if (this.posZ == this.nextZ) {
            ++this.posY;
            this.y = this.adjY.get(this.posY);
            this.nextZ = this.adjZ.findNext(this.nextZ) + 1L;
            if (this.posY == this.nextY) {
                ++this.x;
                this.nextY = this.adjY.findNext(this.nextY) + 1L;
            }
        }
        this.updateOutput();
        ++this.posZ;
        return this.returnTriple;
    }

    public boolean hasPrevious() {
        return this.posZ > this.minZ;
    }

    public TripleID previous() {
        --this.posZ;
        this.posY = this.adjZ.findListIndex(this.posZ);
        this.z = this.adjZ.get(this.posZ);
        this.y = this.adjY.get(this.posY);
        this.x = this.adjY.findListIndex(this.posY) + 1L;
        this.nextY = this.adjY.last(this.x - 1L) + 1L;
        this.nextZ = this.adjZ.last(this.posY) + 1L;
        this.updateOutput();
        return this.returnTriple;
    }

    public void goToStart() {
        this.posZ = this.minZ;
        this.posY = this.adjZ.findListIndex(this.posZ);
        this.z = this.adjZ.get(this.posZ);
        this.y = this.adjY.get(this.posY);
        this.x = this.adjY.findListIndex(this.posY) + 1L;
        this.nextY = this.adjY.last(this.x - 1L) + 1L;
        this.nextZ = this.adjZ.last(this.posY) + 1L;
    }

    public long estimatedNumResults() {
        return this.maxZ - this.minZ;
    }

    public ResultEstimationType numResultEstimation() {
        if (this.patX != 0L && this.patY == 0L && this.patZ != 0L) {
            return ResultEstimationType.UP_TO;
        }
        return ResultEstimationType.EXACT;
    }

    public boolean canGoTo() {
        return this.pattern.isEmpty();
    }

    public void goTo(long pos) {
        if (!this.canGoTo()) {
            throw new IllegalAccessError("Cannot goto on this bitmaptriples pattern");
        }
        if (pos >= this.adjZ.getNumberOfElements()) {
            throw new ArrayIndexOutOfBoundsException("Cannot goTo beyond last triple");
        }
        this.posZ = pos;
        this.posY = this.adjZ.findListIndex(this.posZ);
        this.z = this.adjZ.get(this.posZ);
        this.y = this.adjY.get(this.posY);
        this.x = this.adjY.findListIndex(this.posY) + 1L;
        this.nextY = this.adjY.last(this.x - 1L) + 1L;
        this.nextZ = this.adjZ.last(this.posY) + 1L;
    }

    public TripleComponentOrder getOrder() {
        return this.triples.order;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long getLastTriplePosition() {
        return this.lastPosition;
    }
}

