/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.dictionary.DictionaryCat;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleIDComparator;
import org.rdfhdt.hdt.triples.Triples;

public class BitmapTriplesIteratorCat
implements IteratorTripleID {
    int count = 1;
    Triples hdt1;
    Triples hdt2;
    Iterator<TripleID> list;
    DictionaryCat dictionaryCat;
    TripleIDComparator tripleIDComparator = new TripleIDComparator(TripleComponentOrder.SPO);

    public BitmapTriplesIteratorCat(Triples hdt1, Triples hdt2, DictionaryCat dictionaryCat) {
        this.dictionaryCat = dictionaryCat;
        this.hdt1 = hdt1;
        this.hdt2 = hdt2;
        if (this.hdt1.getNumberOfElements() == 0L && this.hdt2.getNumberOfElements() == 0L) {
            this.list = new ArrayList().listIterator();
        } else {
            this.list = this.getTripleID(1).listIterator();
            ++this.count;
        }
    }

    public boolean hasPrevious() {
        return false;
    }

    public TripleID previous() {
        return null;
    }

    public void goToStart() {
    }

    public boolean canGoTo() {
        return false;
    }

    public void goTo(long pos) {
    }

    public long estimatedNumResults() {
        return this.hdt1.searchAll().estimatedNumResults() + this.hdt2.searchAll().estimatedNumResults();
    }

    public ResultEstimationType numResultEstimation() {
        return null;
    }

    public TripleComponentOrder getOrder() {
        return null;
    }

    public long getLastTriplePosition() {
        throw new NotImplementedException();
    }

    public boolean hasNext() {
        if ((long)this.count < this.dictionaryCat.getMappingS().size()) {
            return true;
        }
        return this.list.hasNext();
    }

    public TripleID next() {
        if (this.list.hasNext()) {
            return this.list.next();
        }
        this.list = this.getTripleID(this.count).listIterator();
        ++this.count;
        if (this.count % 100000 == 0) {
            System.out.println(this.count);
        }
        return this.list.next();
    }

    public void remove() {
    }

    private List<TripleID> getTripleID(int count) {
        HashSet<TripleID> set = new HashSet<TripleID>();
        ArrayList<Long> mapping = null;
        ArrayList<Integer> mappingType = null;
        mapping = this.dictionaryCat.getMappingS().getMapping(count);
        mappingType = this.dictionaryCat.getMappingS().getType(count);
        for (int i = 0; i < mapping.size(); ++i) {
            IteratorTripleID it;
            if (mappingType.get(i) == 1) {
                it = this.hdt1.search(new TripleID(mapping.get(i).longValue(), 0L, 0L));
                while (it.hasNext()) {
                    set.add(this.mapTriple((TripleID)it.next(), 1));
                }
            }
            if (mappingType.get(i) != 2) continue;
            it = this.hdt2.search(new TripleID(mapping.get(i).longValue(), 0L, 0L));
            while (it.hasNext()) {
                set.add(this.mapTriple((TripleID)it.next(), 2));
            }
        }
        ArrayList<TripleID> triples = new ArrayList<TripleID>(set);
        Collections.sort(triples, this.tripleIDComparator);
        return triples;
    }

    public TripleID mapTriple(TripleID tripleID, int num) {
        if (num == 1) {
            long new_subject1 = this.mapIdSection(tripleID.getSubject(), this.dictionaryCat.getAllMappings().get("SH1"), this.dictionaryCat.getAllMappings().get("S1"));
            long new_predicate1 = this.mapIdPredicate(tripleID.getPredicate(), this.dictionaryCat.getAllMappings().get("P1"));
            long new_object1 = this.mapIdSection(tripleID.getObject(), this.dictionaryCat.getAllMappings().get("SH1"), this.dictionaryCat.getAllMappings().get("O1"));
            return new TripleID(new_subject1, new_predicate1, new_object1);
        }
        long new_subject2 = this.mapIdSection(tripleID.getSubject(), this.dictionaryCat.getAllMappings().get("SH2"), this.dictionaryCat.getAllMappings().get("S2"));
        long new_predicate2 = this.mapIdPredicate(tripleID.getPredicate(), this.dictionaryCat.getAllMappings().get("P2"));
        long new_object2 = this.mapIdSection(tripleID.getObject(), this.dictionaryCat.getAllMappings().get("SH2"), this.dictionaryCat.getAllMappings().get("O2"));
        return new TripleID(new_subject2, new_predicate2, new_object2);
    }

    private long mapIdSection(long id, CatMapping catMappingShared, CatMapping catMapping) {
        if (id <= catMappingShared.getSize()) {
            return catMappingShared.getMapping(id - 1L);
        }
        if (catMapping.getType(id - catMappingShared.getSize() - 1L) == 1L) {
            return catMapping.getMapping(id - catMappingShared.getSize() - 1L);
        }
        return catMapping.getMapping(id - catMappingShared.getSize() - 1L) + this.dictionaryCat.getNumShared();
    }

    private long mapIdPredicate(long id, CatMapping catMapping) {
        return catMapping.getMapping(id - 1L);
    }
}

