/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleIDComparator;
import org.rdfhdt.hdt.triples.Triples;

public class BitmapTriplesIteratorMapDiff
implements IteratorTripleID {
    private final CatMapping subjMapping;
    private final CatMapping objMapping;
    private final CatMapping predMapping;
    private final CatMapping sharedMapping;
    private final long countTriples;
    DictionaryDiff dictionaryDiff;
    Iterator<TripleID> list;
    Triples triples;
    TripleIDComparator tripleIDComparator = new TripleIDComparator(TripleComponentOrder.SPO);
    Bitmap bitArrayDisk;
    private long count;

    public BitmapTriplesIteratorMapDiff(HDT hdtOriginal, Bitmap deleteBitmap, DictionaryDiff dictionaryDiff, long countTriples) {
        this.subjMapping = dictionaryDiff.getAllMappings().get("subject");
        this.objMapping = dictionaryDiff.getAllMappings().get("object");
        this.predMapping = dictionaryDiff.getAllMappings().get("predicate");
        this.sharedMapping = dictionaryDiff.getAllMappings().get("shared");
        this.dictionaryDiff = dictionaryDiff;
        this.countTriples = countTriples;
        this.triples = hdtOriginal.getTriples();
        this.bitArrayDisk = deleteBitmap;
        this.list = this.getTripleID(0L).listIterator();
        ++this.count;
    }

    public boolean hasPrevious() {
        return false;
    }

    public TripleID previous() {
        return null;
    }

    public void goToStart() {
    }

    public boolean canGoTo() {
        return false;
    }

    public void goTo(long pos) {
    }

    public long estimatedNumResults() {
        return this.countTriples;
    }

    public ResultEstimationType numResultEstimation() {
        return null;
    }

    public TripleComponentOrder getOrder() {
        return null;
    }

    public long getLastTriplePosition() {
        throw new NotImplementedException();
    }

    public boolean hasNext() {
        return this.count < this.dictionaryDiff.getMappingBack().getSize() || this.list.hasNext();
    }

    public TripleID next() {
        if (!this.list.hasNext()) {
            this.list = this.getTripleID(this.count).iterator();
            ++this.count;
        }
        return this.list.next();
    }

    private List<TripleID> getTripleID(long count) {
        ArrayList<TripleID> newTriples = new ArrayList<TripleID>();
        if (this.dictionaryDiff.getMappingBack().getSize() > 0L) {
            long mapping = this.dictionaryDiff.getMappingBack().getMapping(count);
            IteratorTripleID it = this.triples.search(new TripleID(mapping, 0L, 0L));
            while (it.hasNext()) {
                TripleID next = (TripleID)it.next();
                if (this.bitArrayDisk.access(it.getLastTriplePosition())) continue;
                newTriples.add(this.mapTriple(next));
            }
        }
        newTriples.sort(this.tripleIDComparator);
        return newTriples;
    }

    public TripleID mapTriple(TripleID tripleID) {
        long type;
        long numShared;
        long subjOld = tripleID.getSubject();
        long newSubjId = subjOld <= (numShared = this.sharedMapping.getSize()) ? (this.sharedMapping.getType(subjOld - 1L) == 1L ? this.sharedMapping.getMapping(subjOld - 1L) : this.sharedMapping.getMapping(subjOld - 1L) + this.dictionaryDiff.getNumShared()) : (this.subjMapping.getType(subjOld - numShared - 1L) == 1L ? this.subjMapping.getMapping(subjOld - numShared - 1L) : this.subjMapping.getMapping(subjOld - numShared - 1L) + this.dictionaryDiff.getNumShared());
        long newPredId = this.predMapping.getMapping(tripleID.getPredicate() - 1L);
        long objOld = tripleID.getObject();
        long newObjId = objOld <= numShared ? ((type = this.sharedMapping.getType(objOld - 1L)) == 1L ? this.sharedMapping.getMapping(objOld - 1L) : this.sharedMapping.getMapping(objOld - 1L) + this.dictionaryDiff.getNumShared()) : (this.objMapping.getType(objOld - numShared - 1L) == 1L ? this.objMapping.getMapping(objOld - numShared - 1L) : this.objMapping.getMapping(objOld - numShared - 1L) + this.dictionaryDiff.getNumShared());
        return new TripleID(newSubjId, newPredId, newObjId);
    }
}

