/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.iterator.SuppliableIteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;

public class BitmapTriplesIteratorYFOQ
implements SuppliableIteratorTripleID {
    private BitmapTriples triples;
    private long lastPosition;
    private TripleID pattern;
    private TripleID returnTriple;
    private long patY;
    private AdjacencyList adjY;
    private AdjacencyList adjZ;
    private long posY;
    long posZ;
    private long prevZ;
    private long nextZ;
    private long maxZ;
    private long x;
    private long y;
    private long z;
    private long numOccurrences;
    private long numOccurrence;
    private long predBase;

    public BitmapTriplesIteratorYFOQ(BitmapTriples triples, TripleID pattern) {
        this.triples = triples;
        this.pattern = new TripleID(pattern);
        this.returnTriple = new TripleID();
        TripleOrderConvert.swapComponentOrder(this.pattern, TripleComponentOrder.SPO, triples.order);
        this.patY = this.pattern.getPredicate();
        if (this.patY == 0L) {
            throw new IllegalArgumentException("This structure is not meant to process this pattern");
        }
        this.adjY = new AdjacencyList(triples.getSeqY(), triples.getBitmapY());
        this.adjZ = new AdjacencyList(triples.getSeqZ(), triples.getBitmapZ());
        this.numOccurrences = triples.predicateIndex.getNumOcurrences(this.patY);
        this.predBase = triples.predicateIndex.getBase(this.patY);
        this.maxZ = triples.adjZ.getNumberOfElements();
        this.goToStart();
    }

    private void updateOutput() {
        this.lastPosition = this.posZ;
        this.returnTriple.setAll(this.x, this.y, this.z);
        TripleOrderConvert.swapComponentOrder(this.returnTriple, this.triples.order, TripleComponentOrder.SPO);
    }

    public boolean hasNext() {
        return this.posZ < this.maxZ && this.numOccurrence < this.numOccurrences || this.posZ <= this.nextZ;
    }

    public TripleID next() {
        if (this.posZ > this.nextZ) {
            ++this.numOccurrence;
            this.posY = this.triples.predicateIndex.getOccurrence(this.predBase, this.numOccurrence);
            this.posZ = this.prevZ = this.adjZ.find(this.posY);
            this.nextZ = this.adjZ.last(this.posY);
            this.x = this.adjY.findListIndex(this.posY) + 1L;
            this.y = this.adjY.get(this.posY);
            this.z = this.adjZ.get(this.posZ);
        } else {
            this.z = this.adjZ.get(this.posZ);
        }
        this.updateOutput();
        ++this.posZ;
        return this.returnTriple;
    }

    public boolean hasPrevious() {
        return this.numOccurrence > 1L || this.posZ >= this.prevZ;
    }

    public TripleID previous() {
        if (this.posZ <= this.prevZ) {
            --this.numOccurrence;
            this.posY = this.triples.predicateIndex.getOccurrence(this.predBase, this.numOccurrence);
            this.prevZ = this.adjZ.find(this.posY);
            this.posZ = this.nextZ = this.adjZ.last(this.posY);
            this.x = this.adjY.findListIndex(this.posY) + 1L;
            this.y = this.adjY.get(this.posY);
            this.z = this.adjZ.get(this.posZ);
        } else {
            this.z = this.adjZ.get(this.posZ);
            --this.posZ;
        }
        this.updateOutput();
        return this.returnTriple;
    }

    public void goToStart() {
        this.numOccurrence = 1L;
        this.posY = this.triples.predicateIndex.getOccurrence(this.predBase, this.numOccurrence);
        this.posZ = this.prevZ = this.adjZ.find(this.posY);
        this.nextZ = this.adjZ.last(this.posY);
        this.x = this.adjY.findListIndex(this.posY) + 1L;
        this.y = this.adjY.get(this.posY);
        this.z = this.adjZ.get(this.posZ);
    }

    public long estimatedNumResults() {
        return this.triples.predicateCount.get(this.patY - 1L);
    }

    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.UNKNOWN;
    }

    public boolean canGoTo() {
        return false;
    }

    public void goTo(long pos) {
        if (!this.canGoTo()) {
            throw new IllegalAccessError("Cannot goto on this bitmaptriples pattern");
        }
    }

    public TripleComponentOrder getOrder() {
        return this.triples.order;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long getLastTriplePosition() {
        return this.lastPosition;
    }
}

