/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.TripleID;

public class TripleOrderConvert {
    private static final boolean[][] swap1tab = new boolean[][]{{false, false, true, true, true, false}, {false, false, true, false, true, true}, {true, true, false, false, false, true}, {true, false, false, false, true, false}, {true, true, false, true, false, false}, {false, true, true, true, false, false}};
    private static final boolean[][] swap2tab = new boolean[][]{{false, false, false, false, true, true}, {false, false, true, true, false, false}, {false, false, false, false, true, true}, {true, true, false, false, false, false}, {false, false, true, true, false, false}, {true, true, false, false, false, false}};
    private static final boolean[][] swap3tab = new boolean[][]{{false, true, false, true, false, false}, {true, false, false, false, false, true}, {false, true, false, true, false, false}, {false, false, true, false, true, false}, {true, false, false, false, false, true}, {false, false, true, false, true, false}};

    private TripleOrderConvert() {
    }

    public static void swapComponentOrder(TripleID triple, TripleComponentOrder from, TripleComponentOrder to) {
        long tmp;
        if (from == to) {
            return;
        }
        if (from == TripleComponentOrder.Unknown || to == TripleComponentOrder.Unknown) {
            throw new IllegalArgumentException("Cannot swap Unknown Orders");
        }
        boolean swap1 = swap1tab[from.ordinal() - 1][to.ordinal() - 1];
        boolean swap2 = swap2tab[from.ordinal() - 1][to.ordinal() - 1];
        boolean swap3 = swap3tab[from.ordinal() - 1][to.ordinal() - 1];
        if (swap1) {
            tmp = triple.getSubject();
            triple.setSubject(triple.getPredicate());
            triple.setPredicate(tmp);
        }
        if (swap2) {
            tmp = triple.getSubject();
            triple.setSubject(triple.getObject());
            triple.setObject(tmp);
        }
        if (swap3) {
            tmp = triple.getPredicate();
            triple.setPredicate(triple.getObject());
            triple.setObject(tmp);
        }
    }
}

