/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.crc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.util.crc.CRC;

public class CRCInputStream
extends FilterInputStream {
    protected CRC crc;

    public CRCInputStream(InputStream in, CRC crc) {
        super(in);
        this.crc = crc;
    }

    public void setCRC(CRC crc) {
        this.crc = crc;
    }

    public CRC getCRC() {
        return this.crc;
    }

    public boolean readCRCAndCheck() throws IOException {
        return this.crc.readAndCheck(this.in);
    }

    @Override
    public int read() throws IOException {
        int val = this.in.read();
        this.crc.update((byte)(val & 0xFF));
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.in.read(b, off, len);
        this.crc.update(b, off, ret);
        return ret;
    }
}

