/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class BigByteBuffer {
    static final int BUFFER_SIZE = 8192;
    static int maxBufferSize = 0x7FFFFFFA;
    private final List<byte[]> buffers;

    public static BigByteBuffer allocate(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Can't allocate ByteBuffer with a negative size: " + size);
        }
        if (size == 0L) {
            return new BigByteBuffer(List.of());
        }
        int bufferCount = (int)((size - 1L) / (long)maxBufferSize + 1L);
        ArrayList<byte[]> buffers = new ArrayList<byte[]>(bufferCount);
        int lastNodeSize = (int)(size % (long)maxBufferSize);
        if (lastNodeSize == 0) {
            for (int i = 0; i < bufferCount; ++i) {
                buffers.add(new byte[maxBufferSize]);
            }
        } else {
            for (int i = 0; i < bufferCount - 1; ++i) {
                buffers.add(new byte[maxBufferSize]);
            }
            buffers.add(new byte[lastNodeSize]);
        }
        return new BigByteBuffer(buffers);
    }

    private BigByteBuffer(List<byte[]> buffers) {
        this.buffers = buffers;
    }

    List<byte[]> getBuffers() {
        return this.buffers;
    }

    public long size() {
        return this.buffers.stream().mapToLong(l -> ((byte[])l).length).sum();
    }

    private int getBufferOffset(long index) {
        return (int)(index % (long)maxBufferSize);
    }

    private int getBufferIndex(long index) {
        return (int)(index / (long)maxBufferSize);
    }

    public byte get(long index) {
        int buffer = this.getBufferIndex(index);
        int inBufferIndex = this.getBufferOffset(index);
        if (buffer < 0 || buffer >= this.buffers.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffers.get(buffer)[inBufferIndex];
    }

    public void set(long index, byte value) {
        int buffer = this.getBufferIndex(index);
        int inBufferIndex = this.getBufferOffset(index);
        if (buffer < 0 || buffer >= this.buffers.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.buffers.get((int)buffer)[inBufferIndex] = value;
    }

    public void set(long index, byte[] value, int offset, int length) {
        int buffer2;
        int buffer1 = this.getBufferIndex(index);
        if (buffer1 == (buffer2 = this.getBufferIndex(index + (long)length - 1L))) {
            byte[] b = this.buffers.get(buffer1);
            System.arraycopy(value, offset, b, this.getBufferOffset(index), length);
        } else {
            byte[] b1 = this.buffers.get(buffer1);
            byte[] b2 = this.buffers.get(buffer2);
            int toRead = b1.length - this.getBufferOffset(index);
            System.arraycopy(value, offset, b1, this.getBufferOffset(index), toRead);
            System.arraycopy(value, offset + toRead, b2, this.getBufferOffset(index + (long)toRead), length - toRead);
        }
    }

    public void get(byte[] dst, long position, int offset, int length) {
        int buffer2;
        int buffer1 = this.getBufferIndex(position);
        if (buffer1 == (buffer2 = this.getBufferIndex(position + (long)length - 1L))) {
            byte[] b = this.buffers.get(buffer1);
            System.arraycopy(b, this.getBufferOffset(position), dst, offset, length);
        } else {
            byte[] b1 = this.buffers.get(buffer1);
            byte[] b2 = this.buffers.get(buffer2);
            int toRead = b1.length - this.getBufferOffset(position);
            System.arraycopy(b1, this.getBufferOffset(position), dst, offset, toRead);
            System.arraycopy(b2, this.getBufferOffset(position + (long)toRead), dst, offset + toRead, length - toRead);
        }
    }

    public void readStream(InputStream input, long index, long length, ProgressListener listener) throws IOException {
        long remaining = length;
        long currentIndex = index;
        int b = this.getBufferIndex(index);
        ListenerUtil.notify(listener, "Reading buffer", 0.0f, length);
        while (remaining > 0L) {
            int offset = this.getBufferOffset(currentIndex);
            byte[] buffer = this.buffers.get(b);
            int read = (int)Math.min((long)(buffer.length - offset), currentIndex + remaining);
            this.readStreamInto(input, buffer, offset, read, listener, currentIndex - index, length);
            currentIndex += (long)read;
            ListenerUtil.notify(listener, "Reading buffer", length - (remaining -= (long)read), length);
            ++b;
        }
    }

    private void readStreamInto(InputStream input, byte[] dst, int start, int length, ProgressListener listener, long offset, long end) throws IOException {
        int nRead;
        int pos = 0;
        while ((nRead = input.read(dst, start, length - pos)) > 0) {
            ListenerUtil.notify(listener, "Reading buffer", (long)(pos += nRead) + offset, end);
        }
        if (pos != length) {
            throw new IOException("EOF while reading array from InputStream");
        }
    }

    public void writeStream(OutputStream stream, long offset, long length, ProgressListener listener) throws IOException {
        byte[] buffer = new byte[8192];
        long end = offset + length;
        long write = 0L;
        ListenerUtil.notify(listener, "Writing buffer", 0.0f, length);
        for (long index = offset; index < end; index += 8192L) {
            int toWrite = (int)Math.min(end - index, 8192L);
            this.get(buffer, index, 0, toWrite);
            stream.write(buffer, 0, toWrite);
            ListenerUtil.notify(listener, "Writing buffer", write += (long)toWrite, length);
        }
    }
}

