/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BigMappedByteBuffer {
    static long maxBufferSize = Integer.MAX_VALUE;
    private final List<ByteBuffer> buffers;

    public static BigMappedByteBuffer ofFileChannel(FileChannel ch, FileChannel.MapMode mode, long position, long size) throws IOException {
        int bufferCount = (int)((size - 1L) / maxBufferSize) + 1;
        BigMappedByteBuffer buffer = new BigMappedByteBuffer(new ArrayList<ByteBuffer>());
        for (int i = 0; i < bufferCount; ++i) {
            long mapSize = i == bufferCount - 1 && size % maxBufferSize != 0L ? size % maxBufferSize : maxBufferSize;
            buffer.buffers.add(ch.map(mode, position + (long)i * maxBufferSize, mapSize));
        }
        return buffer;
    }

    private BigMappedByteBuffer(List<ByteBuffer> buffers) {
        this.buffers = buffers;
    }

    private BigMappedByteBuffer(BigMappedByteBuffer other, Function<ByteBuffer, ByteBuffer> map) {
        this(other.buffers.stream().map(map).collect(Collectors.toList()));
    }

    List<ByteBuffer> getBuffers() {
        return this.buffers;
    }

    public void order(ByteOrder order) {
        this.buffers.forEach(b -> b.order(order));
    }

    public long capacity() {
        return this.buffers.stream().mapToLong(Buffer::capacity).sum();
    }

    private int getBufferOffset(long index) {
        return (int)(index % maxBufferSize);
    }

    private int getBufferIndex(long index) {
        return (int)(index / maxBufferSize);
    }

    public byte get(long index) {
        int buffer = this.getBufferIndex(index);
        int inBufferIndex = this.getBufferOffset(index);
        if (buffer < 0 || buffer >= this.buffers.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffers.get(buffer).get(inBufferIndex);
    }

    public void position(long position) {
        int i;
        int mid = this.getBufferIndex(position);
        for (i = 0; i < mid; ++i) {
            this.buffers.get(i).position((int)maxBufferSize);
        }
        this.buffers.get(mid).position(this.getBufferOffset(position));
        for (i = mid + 1; i < this.buffers.size(); ++i) {
            this.buffers.get(i).position(0);
        }
    }

    public long position() {
        long pos = 0L;
        for (ByteBuffer b : this.buffers) {
            pos += (long)b.position();
            if (!b.hasRemaining()) continue;
            break;
        }
        return pos;
    }

    public BigMappedByteBuffer duplicate() {
        return new BigMappedByteBuffer(this, ByteBuffer::duplicate);
    }

    public boolean hasRemaining() {
        return this.position() < this.capacity();
    }

    public byte get() {
        return this.buffers.get(this.getBufferIndex(this.position())).get();
    }

    public void rewind() {
        this.buffers.forEach(ByteBuffer::rewind);
    }

    public void get(byte[] dst, int offset, int length) {
        int buffer2;
        long position = this.position();
        int buffer1 = this.getBufferIndex(position);
        if (buffer1 == (buffer2 = this.getBufferIndex(position + (long)length - 1L))) {
            ByteBuffer b = this.buffers.get(buffer1);
            b.get(dst, offset, length);
        } else {
            ByteBuffer b1 = this.buffers.get(buffer1);
            ByteBuffer b2 = this.buffers.get(buffer2);
            int toRead = b1.capacity() - this.getBufferOffset(position);
            b1.get(dst, offset, toRead);
            b2.get(dst, offset + toRead, length - toRead);
        }
    }
}

