/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ea.boot.configuration;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.client.HttpClient;
import org.rdlinux.ea.EasyAuthRequest;
import org.rdlinux.ea.EzAuthClientHttpRequestInterceptor;
import org.rdlinux.ea.boot.configuration.EzAuthHttpClientProperties;
import org.rdlinux.ea.boot.configuration.SecurityConfigurationAdvice;
import org.rdlinux.ea.interceptor.EsFeignAuthRequestInterceptor;
import org.rdlinux.ea.interceptor.EsRestTemplateRequestInterceptor;
import org.rdlinux.luava.http.CloseableHttpClientBuilder;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={EzAuthHttpClientProperties.class})
@AutoConfigureBefore(value={SecurityConfigurationAdvice.class})
public class EzAuthHttpClientAutoConfiguration
implements ApplicationContextAware {
    @Resource
    private EasyAuthRequest easyAuthRequest;
    @Resource
    private EzAuthHttpClientProperties restTemplateProperties;
    private ApplicationContext applicationContext;

    @Bean
    @LoadBalanced
    @ConditionalOnProperty(prefix="http-client", value={"enable-rest-template"}, havingValue="true", matchIfMissing=true)
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        this.restTemplateProperties.getTemplatePool().setConnectionManagerShared(Boolean.valueOf(true));
        CloseableHttpClientBuilder clientBuilder = new CloseableHttpClientBuilder();
        clientBuilder.setConnectPool(this.restTemplateProperties.getTemplatePool());
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)clientBuilder.build());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)httpRequestFactory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        ArrayList<Object> interceptorList = new ArrayList<Object>();
        Map interfaceMap = this.applicationContext.getBeansOfType(EzAuthClientHttpRequestInterceptor.class);
        if (!interfaceMap.isEmpty()) {
            interceptorList.addAll(interfaceMap.values());
        }
        if (this.restTemplateProperties.getEnabledRestTemplateAuth().booleanValue()) {
            interceptorList.add(new EsRestTemplateRequestInterceptor(this.easyAuthRequest));
        }
        restTemplate.setInterceptors(interceptorList);
        return restTemplate;
    }

    @Bean
    @ConditionalOnProperty(prefix="http-client", value={"enabled-feign-auth"}, havingValue="true", matchIfMissing=true)
    public EsFeignAuthRequestInterceptor esFeignAuthRequestInterceptor() {
        return new EsFeignAuthRequestInterceptor(this.easyAuthRequest);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

