/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ea.boot.configuration;

import javax.annotation.Resource;
import org.rdlinux.ea.EasyAuthRequest;
import org.rdlinux.ea.EasyAuthRequestConfig;
import org.rdlinux.ea.boot.configuration.EzSecurityClientProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EzSecurityClientProperties.class})
@ConditionalOnProperty(prefix="ez-security", name={"client-id", "client-secret", "auth-be-url"})
public class EzAuthRequestAutoConfiguration {
    @Resource
    private EzSecurityClientProperties easyAuthRequestProperties;

    @Bean
    public EasyAuthRequest easyAuthRequest() {
        EasyAuthRequestConfig clientRequest = this.easyAuthRequestProperties.getClientRequest();
        EasyAuthRequestConfig requestConfig = new EasyAuthRequestConfig();
        requestConfig.setServerPath(this.easyAuthRequestProperties.getAuthBeUrl());
        requestConfig.setAuthServiceApiPrefix(clientRequest.getAuthServiceApiPrefix());
        requestConfig.setClientId(this.easyAuthRequestProperties.getClientId());
        requestConfig.setClientSecret(this.easyAuthRequestProperties.getClientSecret());
        requestConfig.setPool(clientRequest.getPool());
        requestConfig.setClientName(clientRequest.getClientName());
        requestConfig.setAccessTokenHeader(requestConfig.getAccessTokenHeader());
        return new EasyAuthRequest(requestConfig);
    }
}

