/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ea.boot.configuration;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.ServletRequest;
import org.apache.http.Header;
import org.rdlinux.ea.EasyAuthRequest;
import org.rdlinux.ea.EncryptionJwtAuthorizedAdvice;
import org.rdlinux.ea.EzOauth2AuthorizedAdvice;
import org.rdlinux.ea.boot.configuration.EzSecurityClientProperties;
import org.rdlinux.ezsecurity.ResponseRetConvert;
import org.rdlinux.ezsecurity.shiro.security.client.AuthClient;
import org.rdlinux.ezsecurity.shiro.security.client.impl.eaoauth2.EzAuthOauth2Client;
import org.rdlinux.ezsecurity.shiro.security.client.impl.encryptionjwt.EncryptionJwtAuthClient;
import org.rdlinux.ezsecurity.shiro.security.client.impl.encryptionjwt.EncryptionJwtProfileCreator;
import org.rdlinux.ezsecurity.shiro.security.client.impl.encryptionjwt.EzAuthEncryptionJwtAuthClient;
import org.rdlinux.ezsecurity.shiro.security.profile.SubjectProfile;
import org.rdlinux.ezsecurity.shiro.security.rootfilter.exception.handler.ShiroFilterExceptionHandler;
import org.rdlinux.ezsecurity.shiro.security.rootfilter.exception.handler.impl.DefaultShiroFilterExceptionHandler;
import org.rdlinux.ezsecurity.spring.boot.autoconfig.EzSecurityAutoConfiguration;
import org.rdlinux.ezsecurity.spring.boot.autoconfig.EzSecurityConfigurationAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;

@Configuration
@EnableConfigurationProperties(value={EzSecurityClientProperties.class})
@AutoConfigureBefore(value={EzSecurityAutoConfiguration.class})
public class SecurityConfigurationAdvice
implements EzSecurityConfigurationAdvice,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfigurationAdvice.class);
    @Resource
    private EzSecurityClientProperties ezSecurityClientProperties;
    private ApplicationContext applicationContext;
    @Resource
    private EasyAuthRequest easyAuthRequest;

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public EncryptionJwtProfileCreator encryptionJwtProfileCreator() {
        return new EncryptionJwtProfileCreator(this.ezSecurityClientProperties.getAuthPublicKey());
    }

    private Set<String> getUserRole(SubjectProfile profile) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", profile.getId());
        return (Set)this.easyAuthRequest.getRequest((TypeReference)new TypeReference<Set<String>>(){}, "/api/role/getUserRoleCode", param, new Header[0]);
    }

    private Set<String> getUserPermission(SubjectProfile profile) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", profile.getId());
        return (Set)this.easyAuthRequest.getRequest((TypeReference)new TypeReference<Set<String>>(){}, "/api/permission/getUserPermissionCode", param, new Header[0]);
    }

    @Bean
    public EzAuthEncryptionJwtAuthClient userAuthClient() {
        final EzAuthOauth2Client oauth2Client = this.ezAuthOauth2Client();
        oauth2Client.init();
        EzAuthEncryptionJwtAuthClient client = new EzAuthEncryptionJwtAuthClient("EC_JWT_USER", "x-auth-token", this.encryptionJwtProfileCreator()){

            public Set<String> getRoles(SubjectProfile profile) {
                return SecurityConfigurationAdvice.this.getUserRole(profile);
            }

            public Set<String> getPermissions(SubjectProfile profile) {
                return SecurityConfigurationAdvice.this.getUserPermission(profile);
            }

            public void onAuthorized(ServletRequest request) {
                Map adviceMap = SecurityConfigurationAdvice.this.applicationContext.getBeansOfType(EncryptionJwtAuthorizedAdvice.class);
                ArrayList advices = new ArrayList(adviceMap.values());
                for (EncryptionJwtAuthorizedAdvice advice : advices) {
                    advice.advice(request);
                }
            }

            public String getLoginUrl() {
                return oauth2Client.getLoginUrl();
            }
        };
        client.setSignOutAfterUrl(this.ezSecurityClientProperties.getSignOutAfterUrl());
        client.setHomePage(this.ezSecurityClientProperties.getHomePage());
        client.setLazyAuth(false);
        return client;
    }

    private EzAuthOauth2Client ezAuthOauth2Client() {
        EzAuthOauth2Client client = new EzAuthOauth2Client(this.ezSecurityClientProperties.getClientId(), this.ezSecurityClientProperties.getClientSecret(), this.ezSecurityClientProperties.getAuthFeUrl(), this.ezSecurityClientProperties.getAuthBeUrl()){

            public Set<String> getRoles(SubjectProfile profile) {
                return SecurityConfigurationAdvice.this.getUserRole(profile);
            }

            public Set<String> getPermissions(SubjectProfile profile) {
                return SecurityConfigurationAdvice.this.getUserPermission(profile);
            }

            public void onAuthorized(ServletRequest request) {
                Map adviceMap = SecurityConfigurationAdvice.this.applicationContext.getBeansOfType(EzOauth2AuthorizedAdvice.class);
                ArrayList advices = new ArrayList(adviceMap.values());
                for (EzOauth2AuthorizedAdvice advice : advices) {
                    advice.advice(request);
                }
            }
        };
        client.setComputeRedirectUrl(this.ezSecurityClientProperties.isComputeEzOauth2CallbackUrl());
        client.setCtx(this.ezSecurityClientProperties.getCtx());
        client.setRedirectApi(this.ezSecurityClientProperties.getEzOauth2RedirectApi());
        client.setRedirectUrl(this.ezSecurityClientProperties.getEzOauth2RedirectUrl());
        client.setScope(this.ezSecurityClientProperties.getEzOauth2Scope().name());
        client.setLazyAuth(true);
        return client;
    }

    @Bean
    public EncryptionJwtAuthClient applicationAuthClient() {
        EncryptionJwtAuthClient client = new EncryptionJwtAuthClient("EC_JWT_APPLICATION", "x-auth-access-token", this.encryptionJwtProfileCreator()){

            public Set<String> getRoles(SubjectProfile profile) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("applicationId", profile.getId());
                return (Set)SecurityConfigurationAdvice.this.easyAuthRequest.getRequest((TypeReference)new TypeReference<Set<String>>(){}, "/api/role/getApplicationRoleCode", param, new Header[0]);
            }

            public Set<String> getPermissions(SubjectProfile profile) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("applicationId", profile.getId());
                return (Set)SecurityConfigurationAdvice.this.easyAuthRequest.getRequest((TypeReference)new TypeReference<Set<String>>(){}, "/api/permission/getApplicationPermissionCode", param, new Header[0]);
            }
        };
        client.setSignOutAfterUrl(this.ezSecurityClientProperties.getSignOutAfterUrl());
        client.setHomePage(this.ezSecurityClientProperties.getHomePage());
        client.setLazyAuth(false);
        return client;
    }

    public Map<String, Filter> getFilters() {
        return null;
    }

    public List<AuthClient> getClients(List<AuthClient> clients) {
        clients.add((AuthClient)this.userAuthClient());
        clients.add((AuthClient)this.applicationAuthClient());
        clients.add((AuthClient)this.ezAuthOauth2Client());
        Map authClientMap = this.applicationContext.getBeansOfType(AuthClient.class);
        if (!authClientMap.isEmpty()) {
            clients.addAll(authClientMap.values());
        }
        return clients;
    }

    public ShiroFilterExceptionHandler getShiroFilterExceptionHandler() {
        try {
            return (ShiroFilterExceptionHandler)this.applicationContext.getBean(ShiroFilterExceptionHandler.class);
        }
        catch (BeansException e) {
            return new DefaultShiroFilterExceptionHandler();
        }
    }

    public ResponseRetConvert getResponseRetConvert() {
        try {
            return (ResponseRetConvert)this.applicationContext.getBean(ResponseRetConvert.class);
        }
        catch (BeansException e) {
            return new ResponseRetConvert(){};
        }
    }
}

