/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.content.entityinfo.build;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.content.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.content.entityinfo.EntityInfoBuildConfig;
import org.rdlinux.ezmybatis.core.content.entityinfo.build.EntityInfoBuild;
import org.rdlinux.ezmybatis.utils.HumpLineStringUtils;

public class OracleEntityInfoBuild
implements EntityInfoBuild {
    private static volatile OracleEntityInfoBuild instance;

    protected OracleEntityInfoBuild() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OracleEntityInfoBuild getInstance() {
        if (instance != null) return instance;
        Class<OracleEntityInfoBuild> clazz = OracleEntityInfoBuild.class;
        synchronized (OracleEntityInfoBuild.class) {
            if (instance != null) return instance;
            instance = new OracleEntityInfoBuild();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public EntityClassInfo buildInfo(Configuration configuration, Class<?> ntClass) {
        EntityInfoBuildConfig buildConfig = configuration.isMapUnderscoreToCamelCase() ? new EntityInfoBuildConfig(EntityInfoBuildConfig.ColumnHandle.ToUnderAndUpper) : new EntityInfoBuildConfig(EntityInfoBuildConfig.ColumnHandle.ORIGINAL);
        return new EntityClassInfo(ntClass, buildConfig);
    }

    @Override
    public String computeFieldNameByColumn(Configuration configuration, String column) {
        if (configuration.isMapUnderscoreToCamelCase()) {
            if (column.matches("^.*[a-z]+.*$") && column.matches("^.*[A-Z]+.*$")) {
                return column;
            }
            if (column.matches("^.*[a-z]+.*$")) {
                return HumpLineStringUtils.lineToHump(column, "_");
            }
            return HumpLineStringUtils.lineToHump(column.toLowerCase(), "_");
        }
        return column.toLowerCase();
    }

    @Override
    public DbType getSupportedDbType() {
        return DbType.ORACLE;
    }
}

