/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.interceptor.executor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.rdlinux.ezmybatis.core.interceptor.InterceptorLogic;
import org.rdlinux.ezmybatis.core.interceptor.InterceptorLogicResult;
import org.rdlinux.ezmybatis.core.mapper.EzBaseMapper;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class MapperParamInitLogic
implements InterceptorLogic {
    private static Set<String> methodNames;

    @Override
    public InterceptorLogicResult invokeBefore(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String methodId = mappedStatement.getId();
        int index = methodId.lastIndexOf(".");
        String methodName = methodId.substring(index + 1);
        String className = methodId.substring(0, index);
        Class<?> mapperClass = Class.forName(className);
        if (EzBaseMapper.class.isAssignableFrom(mapperClass) && methodNames.contains(methodName)) {
            Class<?> etClass = ReflectionUtils.getGenericSuperinterface(mapperClass, 0, 0);
            Map param = (Map)invocation.getArgs()[1];
            param.put("mp_mapperClass", mapperClass);
            param.put("mp_ntClass", etClass);
            param.put("mp_configuration", mappedStatement.getConfiguration());
        } else if (EzMapper.class.isAssignableFrom(mapperClass)) {
            Map param = (Map)invocation.getArgs()[1];
            param.put("mp_mapperClass", mapperClass);
            param.put("mp_configuration", mappedStatement.getConfiguration());
            if (methodName.equals("delete")) {
                Object entity = param.get("mp_entity");
                Assert.notNull(entity, "entity can not be null");
                param.put("mp_ntClass", entity.getClass());
            } else if (methodName.equals("batchDelete")) {
                List entitys = (List)param.get("mp_entitys");
                Assert.notEmpty(entitys, "entitys can not be null");
                param.put("mp_ntClass", entitys.get(0).getClass());
            }
        }
        return new InterceptorLogicResult(true, false);
    }

    static {
        Method[] declaredMethods = EzBaseMapper.class.getDeclaredMethods();
        methodNames = Arrays.stream(declaredMethods).map(Method::getName).collect(Collectors.toSet());
    }
}

