/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.condition.compare;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.content.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.content.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.DbKeywordQMFactory;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Operator;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;

public class FieldCompareCondition
implements Condition {
    private Condition.LogicalOperator logicalOperator;
    private EntityTable leftTable;
    private String leftField;
    private Operator operator;
    private EntityTable rightTable;
    private String rightField;

    public FieldCompareCondition(EntityTable leftTable, String leftField, Operator operator, EntityTable rightTable, String rightField) {
        this.logicalOperator = Condition.LogicalOperator.AND;
        this.leftTable = leftTable;
        this.leftField = leftField;
        this.operator = operator;
        this.rightTable = rightTable;
        this.rightField = rightField;
    }

    public FieldCompareCondition(Condition.LogicalOperator logicalOperator, EntityTable leftTable, String leftField, Operator operator, EntityTable rightTable, String rightField) {
        this.logicalOperator = logicalOperator;
        this.leftTable = leftTable;
        this.leftField = leftField;
        this.operator = operator;
        this.rightTable = rightTable;
        this.rightField = rightField;
    }

    @Override
    public Condition.LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    @Override
    public String toSqlPart(Configuration configuration, MybatisParamHolder mybatisParamHolder) {
        EntityClassInfo etInfo = EzEntityClassInfoFactory.forClass(configuration, this.getLeftTable().getEtType());
        EntityClassInfo oEtInfo = EzEntityClassInfoFactory.forClass(configuration, this.getRightTable().getEtType());
        String keywordQM = DbKeywordQMFactory.getKeywordQM(DbTypeUtils.getDbType(configuration));
        return " " + this.getLeftTable().getAlias() + "." + keywordQM + etInfo.getFieldInfo(this.getLeftField()).getColumnName() + keywordQM + " " + this.getOperator().getOperator() + " " + this.getRightTable().getAlias() + "." + keywordQM + oEtInfo.getFieldInfo(this.getRightField()).getColumnName() + keywordQM + " ";
    }

    public EntityTable getLeftTable() {
        return this.leftTable;
    }

    public String getLeftField() {
        return this.leftField;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public EntityTable getRightTable() {
        return this.rightTable;
    }

    public String getRightField() {
        return this.rightField;
    }
}

