/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisInterceptorChain;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisExecutorInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisResultSetHandlerInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisUpdateInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class EzMybatisContent {
    private static final ConcurrentMap<Configuration, ConfigurationConfig> CFG_CONFIG_MAP = new ConcurrentHashMap<Configuration, ConfigurationConfig>();

    public static void setDbType(Configuration configuration, DbType dbType) {
        DbTypeUtils.setDbType(configuration, dbType);
    }

    public static void init(Configuration configuration) {
        EzMybatisContent.initMapper(configuration);
        EzMybatisContent.initInterceptor(configuration);
    }

    public static void addInsertListener(Configuration configuration, EzMybatisInsertListener listener) {
        EzMybatisContent.checkInit(configuration);
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(configuration);
        configurationConfig.getUpdateInterceptor().addInsertListener(listener);
    }

    public static void addUpdateListener(Configuration configuration, EzMybatisUpdateListener listener) {
        EzMybatisContent.checkInit(configuration);
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(configuration);
        configurationConfig.getUpdateInterceptor().addUpdateListener(listener);
    }

    public static void addDeleteListener(Configuration configuration, EzMybatisDeleteListener listener) {
        EzMybatisContent.checkInit(configuration);
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(configuration);
        configurationConfig.getUpdateInterceptor().addDeleteListener(listener);
    }

    private static void checkInit(Configuration configuration) {
        if (CFG_CONFIG_MAP.get(configuration) == null) {
            EzMybatisContent.init(configuration);
        }
    }

    private static void initMapper(Configuration configuration) {
        configuration.addMapper(EzMapper.class);
    }

    private static void initInterceptor(Configuration configuration) {
        InterceptorChain interceptorChain = (InterceptorChain)ReflectionUtils.getFieldValue((Object)configuration, "interceptorChain");
        EzMybatisInterceptorChain ezMybatisInterceptorChain = new EzMybatisInterceptorChain(interceptorChain);
        ReflectionUtils.setFieldValue((Object)configuration, "interceptorChain", (Object)ezMybatisInterceptorChain);
        ezMybatisInterceptorChain.addEzInterceptor(new EzMybatisResultSetHandlerInterceptor());
        ezMybatisInterceptorChain.addEzInterceptor(new EzMybatisExecutorInterceptor());
        ConfigurationConfig configurationConfig = new ConfigurationConfig().setConfiguration(configuration).setUpdateInterceptor(new EzMybatisUpdateInterceptor());
        CFG_CONFIG_MAP.put(configuration, configurationConfig);
        ezMybatisInterceptorChain.addInterceptor(configurationConfig.getUpdateInterceptor());
    }

    private static class ConfigurationConfig {
        private Configuration configuration;
        private EzMybatisUpdateInterceptor updateInterceptor;

        private ConfigurationConfig() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public EzMybatisUpdateInterceptor getUpdateInterceptor() {
            return this.updateInterceptor;
        }

        public ConfigurationConfig setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ConfigurationConfig setUpdateInterceptor(EzMybatisUpdateInterceptor updateInterceptor) {
            this.updateInterceptor = updateInterceptor;
            return this;
        }
    }
}

