/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.content;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.content.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.content.entityinfo.build.DmEntityInfoBuild;
import org.rdlinux.ezmybatis.core.content.entityinfo.build.EntityInfoBuild;
import org.rdlinux.ezmybatis.core.content.entityinfo.build.MySqlEntityInfoBuild;
import org.rdlinux.ezmybatis.core.content.entityinfo.build.OracleEntityInfoBuild;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;

public class EzEntityClassInfoFactory {
    private static final Map<Configuration, Map<String, EntityClassInfo>> ENTITY_INFO_MAP = new HashMap<Configuration, Map<String, EntityClassInfo>>();
    private static final Map<DbType, EntityInfoBuild> ENTITY_INFO_BUILD_MAP = new HashMap<DbType, EntityInfoBuild>();

    private static EntityClassInfo get(Configuration configuration, Class<?> ntClass) {
        Map<String, EntityClassInfo> entityInfo = ENTITY_INFO_MAP.get(configuration);
        if (entityInfo == null) {
            return null;
        }
        return entityInfo.get(ntClass.getName());
    }

    private static EntityClassInfo buildInfo(Configuration configuration, Class<?> ntClass, EntityInfoBuild entityInfoBuild) {
        Map<Object, Object> entityInfo;
        DbType dbType = DbTypeUtils.getDbType(configuration);
        EntityInfoBuild infoBuild = ENTITY_INFO_BUILD_MAP.get((Object)dbType);
        if (entityInfoBuild != null) {
            infoBuild = entityInfoBuild;
        }
        EntityClassInfo entityClassInfo = infoBuild.buildInfo(configuration, ntClass);
        if (ENTITY_INFO_MAP.get(configuration) == null) {
            entityInfo = new HashMap();
            ENTITY_INFO_MAP.put(configuration, entityInfo);
        } else {
            entityInfo = ENTITY_INFO_MAP.get(configuration);
        }
        entityInfo.put(ntClass.getName(), entityClassInfo);
        return entityClassInfo;
    }

    public static EntityClassInfo forClass(Configuration configuration, Class<?> ntClass) {
        return EzEntityClassInfoFactory.forClass(configuration, ntClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityClassInfo forClass(Configuration configuration, Class<?> ntClass, EntityInfoBuild entityInfoBuild) {
        EntityClassInfo result = EzEntityClassInfoFactory.get(configuration, ntClass);
        if (result == null) {
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                result = EzEntityClassInfoFactory.get(configuration, ntClass);
                if (result == null) {
                    result = EzEntityClassInfoFactory.buildInfo(configuration, ntClass, entityInfoBuild);
                }
            }
        }
        return result;
    }

    public static EntityInfoBuild getEntityInfoBuild(Configuration configuration) {
        return ENTITY_INFO_BUILD_MAP.get((Object)DbTypeUtils.getDbType(configuration));
    }

    static {
        MySqlEntityInfoBuild mySqlEntityInfoBuild = MySqlEntityInfoBuild.getInstance();
        ENTITY_INFO_BUILD_MAP.put(mySqlEntityInfoBuild.getSupportedDbType(), mySqlEntityInfoBuild);
        OracleEntityInfoBuild oracleEntityInfoBuild = OracleEntityInfoBuild.getInstance();
        ENTITY_INFO_BUILD_MAP.put(oracleEntityInfoBuild.getSupportedDbType(), oracleEntityInfoBuild);
        DmEntityInfoBuild dmEntityInfoBuild = DmEntityInfoBuild.getInstance();
        ENTITY_INFO_BUILD_MAP.put(dmEntityInfoBuild.getSupportedDbType(), dmEntityInfoBuild);
    }
}

