/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.interceptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.core.mapper.EzBaseMapper;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class EzMybatisUpdateInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(EzMybatisUpdateInterceptor.class);
    private static final Field MAPPER_METHOD_FIELD = ReflectionUtils.getField(ProviderSqlSource.class, "mapperMethod");
    private final List<EzMybatisInsertListener> insertListeners = new LinkedList<EzMybatisInsertListener>();
    private final List<EzMybatisUpdateListener> updateListeners = new LinkedList<EzMybatisUpdateListener>();
    private final List<EzMybatisDeleteListener> deleteListeners = new LinkedList<EzMybatisDeleteListener>();

    public void addInsertListener(EzMybatisInsertListener insertListener) {
        this.insertListeners.add(insertListener);
    }

    public void addUpdateListener(EzMybatisUpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void addDeleteListener(EzMybatisDeleteListener deleteListener) {
        this.deleteListeners.add(deleteListener);
    }

    protected void onInsert(Object entity) {
        this.insertListeners.forEach(e -> e.onInsert(entity));
    }

    protected void onBatchInsert(List<Object> entitys) {
        this.insertListeners.forEach(e -> e.onBatchInsert(entitys));
    }

    protected void onUpdate(Object entity) {
        this.updateListeners.forEach(e -> e.onUpdate(entity));
    }

    protected void onBatchUpdate(List<Object> entitys) {
        this.updateListeners.forEach(e -> e.onBatchUpdate(entitys));
    }

    protected void onDelete(Object entity) {
        this.deleteListeners.forEach(e -> e.onDelete(entity));
    }

    protected void onBatchDelete(List<Object> entitys) {
        this.deleteListeners.forEach(e -> e.onBatchDelete(entitys));
    }

    protected void onDeleteById(Object id, Class<?> ntClass) {
        this.deleteListeners.forEach(e -> e.onDeleteById(id, ntClass));
    }

    protected void onBatchDeleteById(List<Object> ids, Class<?> ntClass) {
        this.deleteListeners.forEach(e -> e.onBatchDeleteById(ids, ntClass));
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        SqlSource sqlSource = mappedStatement.getSqlSource();
        if (!(sqlSource instanceof ProviderSqlSource)) {
            return invocation.proceed();
        }
        Method mapperMethod = (Method)ReflectionUtils.getFieldValue((Object)sqlSource, MAPPER_METHOD_FIELD);
        if (!mapperMethod.getDeclaringClass().getName().equals(EzBaseMapper.class.getName()) && !mapperMethod.getDeclaringClass().getName().equals(EzMapper.class.getName())) {
            return invocation.proceed();
        }
        String statementId = mappedStatement.getId();
        if (sqlCommandType == SqlCommandType.INSERT) {
            Map param = (Map)args[1];
            if (statementId.endsWith(".insert")) {
                log.debug("on insert");
                this.onInsert(param.get("mp_entity"));
            } else if (statementId.endsWith(".batchInsert")) {
                log.debug("on batch insert");
                this.onBatchInsert((List)param.get("mp_entitys"));
            }
        } else if (sqlCommandType == SqlCommandType.UPDATE) {
            Map param = (Map)args[1];
            if (statementId.endsWith(".update") || statementId.endsWith(".replace")) {
                log.debug("on update");
                this.onUpdate(param.get("mp_entity"));
            } else if (statementId.endsWith(".batchUpdate") || statementId.endsWith(".batchReplace")) {
                log.debug("on batch update");
                this.onBatchUpdate((List)param.get("mp_entitys"));
            }
        } else if (sqlCommandType == SqlCommandType.DELETE) {
            Map param = (Map)args[1];
            if (statementId.endsWith(".ezDelete") || statementId.endsWith(".ezBatchDelete")) {
                log.debug("ez delete \u4e0d\u652f\u6301\u4e8b\u4ef6\u5904\u7406");
            } else if (statementId.endsWith(".delete")) {
                log.debug("on delete");
                this.onDelete(param.get("mp_entity"));
            } else if (statementId.endsWith(".batchDelete")) {
                log.debug("on batch delete");
                this.onBatchDelete((List)param.get("mp_entitys"));
            } else {
                String className = statementId.substring(0, statementId.lastIndexOf("."));
                Class<?> mapperClass = Class.forName(className);
                Class etType = null;
                if (mapperMethod.getDeclaringClass().getName().equals(EzBaseMapper.class.getName())) {
                    etType = ReflectionUtils.getGenericSuperinterface(mapperClass, 0, 0);
                } else if (mapperMethod.getDeclaringClass().getName().equals(EzMapper.class.getName())) {
                    etType = (Class)param.get("mp_ntClass");
                }
                if (statementId.endsWith(".deleteById")) {
                    log.debug("on delete by primary key");
                    this.onDeleteById(param.get("mp_id"), etType);
                } else if (statementId.endsWith(".batchDeleteById")) {
                    log.debug("on batch delete by primary key");
                    this.onBatchDeleteById((List)param.get("mp_ids"), etType);
                }
            }
        }
        return invocation.proceed();
    }
}

