/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlgenerate;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.rdlinux.ezmybatis.utils.Assert;

public class MybatisParamHolder {
    private Map<String, Object> mybatisParam;
    private AtomicInteger pNo = new AtomicInteger(0);

    public MybatisParamHolder(Map<String, Object> mybatisParam) {
        this.mybatisParam = mybatisParam;
    }

    private static String getEscapeChar(Object param) {
        if (param instanceof Number) {
            return "$";
        }
        return "#";
    }

    public <T> T get(String param) {
        return (T)this.mybatisParam.get(param);
    }

    public String getParamName(Object paramValue) {
        Assert.notNull(paramValue, "paramValue can not be null");
        String escape = MybatisParamHolder.getEscapeChar(paramValue);
        String paramName = "mp_" + this.pNo.getAndIncrement();
        this.mybatisParam.put(paramName, paramValue);
        return escape + "{" + paramName + "}";
    }
}

