/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct;

import java.util.LinkedList;
import java.util.List;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.EzParam;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.Where;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ConditionBuilder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.GroupCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.join.JoinType;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;

public class Join
implements SqlStruct {
    private Table table;
    private JoinType joinType;
    private Table joinTable;
    private List<Condition> onConditions;
    private List<Join> joins;

    @Override
    public StringBuilder toSqlPart(StringBuilder sqlBuilder, Configuration configuration, EzParam<?> ezParam, MybatisParamHolder mybatisParamHolder) {
        return this.joinToSql(sqlBuilder, configuration, mybatisParamHolder);
    }

    protected StringBuilder joinToSql(StringBuilder sqlBuilder, Configuration configuration, MybatisParamHolder mybatisParamHolder) {
        StringBuilder sonSql;
        if (this.joinType == JoinType.CrossJoin) {
            sonSql = new StringBuilder();
        } else {
            sonSql = Where.conditionsToSqlPart(new StringBuilder(), configuration, mybatisParamHolder, this.getOnConditions());
            if (sonSql.length() == 0) {
                return sqlBuilder;
            }
        }
        sqlBuilder.append(this.joinType.toSqlStruct()).append(this.joinTable.toSqlStruct(configuration, mybatisParamHolder));
        if (this.joinType != JoinType.CrossJoin) {
            sqlBuilder.append(" ON ");
        }
        sqlBuilder.append((CharSequence)sonSql);
        if (this.getJoins() != null && !this.getJoins().isEmpty()) {
            for (Join join : this.joins) {
                sqlBuilder.append((CharSequence)join.joinToSql(new StringBuilder(), configuration, mybatisParamHolder));
            }
        }
        return sqlBuilder;
    }

    public Join setTable(Table table) {
        this.table = table;
        return this;
    }

    public Join setJoinType(JoinType joinType) {
        this.joinType = joinType;
        return this;
    }

    public Join setJoinTable(Table joinTable) {
        this.joinTable = joinTable;
        return this;
    }

    public Join setOnConditions(List<Condition> onConditions) {
        this.onConditions = onConditions;
        return this;
    }

    public Join setJoins(List<Join> joins) {
        this.joins = joins;
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Table getJoinTable() {
        return this.joinTable;
    }

    public List<Condition> getOnConditions() {
        return this.onConditions;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public static class JoinBuilder<Builder>
    extends ConditionBuilder<Builder, JoinBuilder<Builder>> {
        private Join join;

        public JoinBuilder(Builder builder, Join join) {
            super(builder, join.getOnConditions(), join.getTable(), join.getJoinTable());
            this.sonBuilder = this;
            this.join = join;
        }

        public JoinBuilder<JoinBuilder<Builder>> groupCondition(Condition.LogicalOperator logicalOperator) {
            GroupCondition condition = new GroupCondition(new LinkedList<Condition>(), logicalOperator);
            this.conditions.add(condition);
            Join newJoin = new Join();
            newJoin.setTable(this.join.getTable());
            newJoin.setJoinTable(this.join.getJoinTable());
            newJoin.setOnConditions(condition.getConditions());
            return new JoinBuilder<JoinBuilder<Builder>>(this, newJoin);
        }

        public JoinBuilder<JoinBuilder<Builder>> groupCondition() {
            return this.groupCondition(Condition.LogicalOperator.AND);
        }

        public JoinBuilder<JoinBuilder<Builder>> join(JoinType joinType, Table joinTable) {
            if (this.join.getJoins() == null) {
                this.join.joins = new LinkedList();
            }
            Join newJoin = new Join();
            newJoin.setJoinType(joinType);
            newJoin.setTable(this.join.getJoinTable());
            newJoin.setJoinTable(joinTable);
            newJoin.setOnConditions(new LinkedList<Condition>());
            this.join.joins.add(newJoin);
            return new JoinBuilder<JoinBuilder<Builder>>(this, newJoin);
        }

        public JoinBuilder<JoinBuilder<Builder>> join(Table joinTable) {
            return this.join(JoinType.InnerJoin, joinTable);
        }

        public JoinBuilder<Builder> joinTableCondition() {
            this.table = this.join.getJoinTable();
            this.otherTable = this.join.getTable();
            return this;
        }

        public JoinBuilder<Builder> masterTableCondition() {
            this.table = this.join.getTable();
            this.otherTable = this.join.getJoinTable();
            return this;
        }
    }
}

