/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.condition.between;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Operator;

public abstract class BetweenCondition
implements Condition {
    protected Operator operator = Operator.between;
    protected Condition.LogicalOperator logicalOperator;
    protected Object minValue;
    protected Object maxValue;

    public BetweenCondition(Condition.LogicalOperator logicalOperator, Object minValue, Object maxValue) {
        this.logicalOperator = logicalOperator;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    protected abstract String getSqlField(Configuration var1);

    @Override
    public String toSqlPart(Configuration configuration, MybatisParamHolder mybatisParamHolder) {
        if (this.minValue == null || this.maxValue == null) {
            return "";
        }
        return " " + this.getSqlField(configuration) + " " + this.getOperator().getOperator() + " " + Condition.valueToSqlStruct(configuration, mybatisParamHolder, this.minValue) + " AND " + Condition.valueToSqlStruct(configuration, mybatisParamHolder, this.maxValue) + " ";
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Condition.LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(Condition.LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }
}

