/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class DbTypeUtils {
    private static final ConcurrentMap<Configuration, DbType> DB_TYPE_MAP = new ConcurrentHashMap<Configuration, DbType>();

    public static void setDbType(Configuration configuration, DbType dbType) {
        Assert.notNull(configuration, "configuration can not be null");
        Assert.notNull((Object)dbType, "dbType can not be null");
        DB_TYPE_MAP.put(configuration, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbType getDbType(Configuration configuration) {
        DbType dbType = (DbType)((Object)DB_TYPE_MAP.get(configuration));
        if (dbType == null) {
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                dbType = (DbType)((Object)DB_TYPE_MAP.get(configuration));
                if (dbType == null) {
                    DataSource dataSource = configuration.getEnvironment().getDataSource();
                    String driver = PooledDataSource.class.isAssignableFrom(dataSource.getClass()) ? ((PooledDataSource)dataSource).getDriver() : (dataSource.getClass().getName().contains("druid") ? (String)ReflectionUtils.getFieldValue((Object)dataSource, "driverClass") : (String)ReflectionUtils.getFieldValue((Object)dataSource, "driverClassName"));
                    Assert.notEmpty(driver, "Unsupported db type");
                    if (driver.contains("mysql")) {
                        dbType = DbType.MYSQL;
                    } else if (driver.contains("oracle")) {
                        dbType = DbType.ORACLE;
                    } else if (driver.toLowerCase().contains("dmdriver")) {
                        dbType = DbType.DM;
                    } else {
                        throw new RuntimeException("Unsupported db type");
                    }
                    DB_TYPE_MAP.put(configuration, dbType);
                }
            }
        }
        return dbType;
    }
}

