/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.EzMybatisConfig;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisInterceptorChain;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisExecutorInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisResultSetHandlerInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisUpdateInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.core.sqlgenerate.DbKeywordQMFactory;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class EzMybatisContent {
    private static final ConcurrentMap<Configuration, ConfigurationConfig> CFG_CONFIG_MAP = new ConcurrentHashMap<Configuration, ConfigurationConfig>();

    public static void setDbType(Configuration configuration, DbType dbType) {
        DbTypeUtils.setDbType(configuration, dbType);
    }

    public static void init(EzMybatisConfig config) {
        ConfigurationConfig configurationConfig = new ConfigurationConfig();
        configurationConfig.setConfiguration(config.getConfiguration());
        configurationConfig.setDbKeywordQMFactory(new DbKeywordQMFactory(config));
        CFG_CONFIG_MAP.put(config.getConfiguration(), configurationConfig);
        EzMybatisContent.initMapper(config);
        EzMybatisContent.initInterceptor(config);
    }

    public static String getKeywordQM(Configuration configuration) {
        Assert.notNull(configuration, "configuration can not be null");
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "please init");
        return configurationConfig.getDbKeywordQMFactory().getKeywordQM();
    }

    public static void addInsertListener(EzMybatisConfig config, EzMybatisInsertListener listener) {
        EzMybatisContent.checkInit(config);
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.getUpdateInterceptor().addInsertListener(listener);
    }

    public static void addUpdateListener(EzMybatisConfig config, EzMybatisUpdateListener listener) {
        EzMybatisContent.checkInit(config);
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.getUpdateInterceptor().addUpdateListener(listener);
    }

    public static void addDeleteListener(EzMybatisConfig config, EzMybatisDeleteListener listener) {
        EzMybatisContent.checkInit(config);
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.getUpdateInterceptor().addDeleteListener(listener);
    }

    private static void checkInit(EzMybatisConfig config) {
        if (CFG_CONFIG_MAP.get(config.getConfiguration()) == null) {
            EzMybatisContent.init(config);
        }
    }

    private static void initMapper(EzMybatisConfig config) {
        config.getConfiguration().addMapper(EzMapper.class);
    }

    private static void initInterceptor(EzMybatisConfig config) {
        Configuration configuration = config.getConfiguration();
        InterceptorChain interceptorChain = (InterceptorChain)ReflectionUtils.getFieldValue((Object)configuration, "interceptorChain");
        EzMybatisInterceptorChain ezMybatisInterceptorChain = new EzMybatisInterceptorChain(interceptorChain);
        ReflectionUtils.setFieldValue((Object)configuration, "interceptorChain", (Object)ezMybatisInterceptorChain);
        ezMybatisInterceptorChain.addEzInterceptor(new EzMybatisResultSetHandlerInterceptor());
        ezMybatisInterceptorChain.addEzInterceptor(new EzMybatisExecutorInterceptor());
        ConfigurationConfig configurationConfig = (ConfigurationConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.setUpdateInterceptor(new EzMybatisUpdateInterceptor());
        ezMybatisInterceptorChain.addInterceptor(configurationConfig.getUpdateInterceptor());
    }

    private static class ConfigurationConfig {
        private Configuration configuration;
        private EzMybatisUpdateInterceptor updateInterceptor;
        private DbKeywordQMFactory dbKeywordQMFactory;

        private ConfigurationConfig() {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public EzMybatisUpdateInterceptor getUpdateInterceptor() {
            return this.updateInterceptor;
        }

        public DbKeywordQMFactory getDbKeywordQMFactory() {
            return this.dbKeywordQMFactory;
        }

        public ConfigurationConfig setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ConfigurationConfig setUpdateInterceptor(EzMybatisUpdateInterceptor updateInterceptor) {
            this.updateInterceptor = updateInterceptor;
            return this;
        }

        public ConfigurationConfig setDbKeywordQMFactory(DbKeywordQMFactory dbKeywordQMFactory) {
            this.dbKeywordQMFactory = dbKeywordQMFactory;
            return this;
        }
    }
}

