/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.core.EzParam;
import org.rdlinux.ezmybatis.core.sqlstruct.From;
import org.rdlinux.ezmybatis.core.sqlstruct.GroupBy;
import org.rdlinux.ezmybatis.core.sqlstruct.Having;
import org.rdlinux.ezmybatis.core.sqlstruct.Join;
import org.rdlinux.ezmybatis.core.sqlstruct.Limit;
import org.rdlinux.ezmybatis.core.sqlstruct.OrderBy;
import org.rdlinux.ezmybatis.core.sqlstruct.Select;
import org.rdlinux.ezmybatis.core.sqlstruct.Where;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.group.GroupItem;
import org.rdlinux.ezmybatis.core.sqlstruct.join.JoinType;
import org.rdlinux.ezmybatis.core.sqlstruct.order.OrderItem;
import org.rdlinux.ezmybatis.core.sqlstruct.selectitem.SelectItem;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EzQueryTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;

public class EzQuery<Rt>
extends EzParam<Rt> {
    private Select select;
    private List<Join> joins;
    private GroupBy groupBy;
    private OrderBy orderBy;
    private Having having;
    private Limit limit;

    private EzQuery(Class<Rt> retType) {
        super(retType);
    }

    public static <Rt> EzQueryBuilder<Rt> builder(Class<Rt> retType) {
        return new EzQueryBuilder(retType);
    }

    public Select getSelect() {
        return this.select;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Having getHaving() {
        return this.having;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public static class EzQueryBuilder<Rt> {
        private final EzQuery<Rt> query;

        private EzQueryBuilder(Class<Rt> retType) {
            this.query = new EzQuery(retType);
        }

        public EzQueryBuilder<Rt> from(Table table) {
            this.query.table = table;
            this.query.from = new From(table);
            return this;
        }

        public Select.EzSelectBuilder<EzQueryBuilder<Rt>> select(Table table) {
            if (((EzQuery)this.query).select == null) {
                ((EzQuery)this.query).select = new Select(new LinkedList<SelectItem>());
            }
            return new Select.EzSelectBuilder<EzQueryBuilder<Rt>>(this, ((EzQuery)this.query).select, table);
        }

        public Select.EzSelectBuilder<EzQueryBuilder<Rt>> select() {
            return this.select(this.query.table);
        }

        public Join.JoinBuilder<EzQueryBuilder<Rt>> join(JoinType joinType, Table joinTable) {
            if (this.query.getJoins() == null) {
                ((EzQuery)this.query).joins = new LinkedList();
            }
            Join join = new Join();
            join.setJoinType(joinType);
            join.setTable(this.query.table);
            join.setJoinTable(joinTable);
            join.setOnConditions(new LinkedList<Condition>());
            ((EzQuery)this.query).joins.add(join);
            return new Join.JoinBuilder<EzQueryBuilder<Rt>>(this, join);
        }

        public Join.JoinBuilder<EzQueryBuilder<Rt>> join(Table joinTable) {
            return this.join(JoinType.InnerJoin, joinTable);
        }

        public Join.JoinBuilder<EzQueryBuilder<Rt>> join(EzQuery<?> ezQuery) {
            return this.join(EzQueryTable.of(ezQuery));
        }

        public Where.WhereBuilder<EzQueryBuilder<Rt>> where(Table table) {
            if (this.query.where == null) {
                this.query.where = new Where(new LinkedList<Condition>());
            }
            return new Where.WhereBuilder<EzQueryBuilder<Rt>>(this, this.query.where, table);
        }

        public Where.WhereBuilder<EzQueryBuilder<Rt>> where() {
            return this.where(this.query.table);
        }

        public GroupBy.GroupBuilder<EzQueryBuilder<Rt>> groupBy(Table table) {
            if (((EzQuery)this.query).groupBy == null) {
                ((EzQuery)this.query).groupBy = new GroupBy(new LinkedList<GroupItem>());
            }
            return new GroupBy.GroupBuilder<EzQueryBuilder<Rt>>(this, ((EzQuery)this.query).groupBy, table);
        }

        public GroupBy.GroupBuilder<EzQueryBuilder<Rt>> groupBy() {
            return this.groupBy(this.query.table);
        }

        public OrderBy.OrderBuilder<EzQueryBuilder<Rt>> orderBy(Table table) {
            if (((EzQuery)this.query).orderBy == null) {
                ((EzQuery)this.query).orderBy = new OrderBy(new LinkedList<OrderItem>());
            }
            return new OrderBy.OrderBuilder<EzQueryBuilder<Rt>>(this, ((EzQuery)this.query).orderBy, table);
        }

        public OrderBy.OrderBuilder<EzQueryBuilder<Rt>> orderBy() {
            return this.orderBy(this.query.table);
        }

        public Having.HavingBuilder<EzQueryBuilder<Rt>> having(Table table) {
            if (((EzQuery)this.query).having == null) {
                ((EzQuery)this.query).having = new Having(new LinkedList<Condition>());
            }
            return new Having.HavingBuilder<EzQueryBuilder<Rt>>(this, ((EzQuery)this.query).having, table);
        }

        public Having.HavingBuilder<EzQueryBuilder<Rt>> having() {
            return this.having(this.query.table);
        }

        public EzQueryBuilder<Rt> page(int currentPage, int pageSize) {
            ((EzQuery)this.query).limit = new Limit((currentPage - 1) * pageSize, pageSize);
            return this;
        }

        public EzQuery<Rt> build() {
            return this.query;
        }
    }
}

