/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.interceptor.executor;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Invocation;
import org.rdlinux.ezmybatis.core.EzParam;
import org.rdlinux.ezmybatis.core.interceptor.InterceptorLogic;
import org.rdlinux.ezmybatis.core.interceptor.InterceptorLogicResult;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class ResultMapInitLogic
implements InterceptorLogic {
    public static final ThreadLocal<Class<?>> RET_TYPE_TL = new ThreadLocal();
    private static final Field hasNestedResultMapsFiled = ReflectionUtils.getField(ResultMap.class, "hasNestedResultMaps");

    public static Class<?> getRetType(ResultMap resultMap) {
        Class retType = RET_TYPE_TL.get();
        if (retType == null) {
            retType = resultMap.getType();
        }
        return retType;
    }

    public static void cleanRetType() {
        RET_TYPE_TL.remove();
    }

    @Override
    public InterceptorLogicResult invokeBefore(Invocation invocation) {
        ResultMapInitLogic.cleanRetType();
        if (!(invocation.getTarget() instanceof Executor)) {
            return new InterceptorLogicResult(true, null);
        }
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        if (ms.getResultMaps() == null) {
            return new InterceptorLogicResult(true, null);
        }
        for (ResultMap resultMap : ms.getResultMaps()) {
            Map param;
            if (resultMap.getResultMappings() != null && !resultMap.getResultMappings().isEmpty()) continue;
            if (resultMap.getId().startsWith(EzMapper.class.getName() + "." + "query" + "-") || resultMap.getId().startsWith(EzMapper.class.getName() + "." + "queryOne" + "-")) {
                param = (Map)invocation.getArgs()[1];
                EzParam ezParam = (EzParam)param.get("mp");
                RET_TYPE_TL.set(ezParam.getRetType());
                ReflectionUtils.setFieldValue((Object)resultMap, hasNestedResultMapsFiled, (Object)false);
                continue;
            }
            if (resultMap.getId().startsWith(EzMapper.class.getName() + "." + "selectById" + "-") || resultMap.getId().startsWith(EzMapper.class.getName() + "." + "selectByIds" + "-")) {
                param = (Map)invocation.getArgs()[1];
                Class entityClass = (Class)param.get("mp_ntClass");
                RET_TYPE_TL.set(entityClass);
                ReflectionUtils.setFieldValue((Object)resultMap, hasNestedResultMapsFiled, (Object)false);
                continue;
            }
            if (!resultMap.getId().startsWith(EzMapper.class.getName() + "." + "queryCount" + "-")) continue;
            ReflectionUtils.setFieldValue((Object)resultMap, hasNestedResultMapsFiled, (Object)false);
        }
        return new InterceptorLogicResult(true, null);
    }
}

