/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.mapper.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.annotation.MethodName;
import org.rdlinux.ezmybatis.core.EzDelete;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlgenerate.SqlGenerateFactory;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class EzDeleteProvider {
    public static final String DELETE_METHOD = "delete";
    public static final String BATCH_DELETE_METHOD = "batchDelete";
    public static final String DELETE_BY_ID_METHOD = "deleteById";
    public static final String BATCH_DELETE_BY_ID_METHOD = "batchDeleteById";
    public static final String DELETE_BY_EZ_DELETE_METHOD = "deleteByEzDelete";
    public static final String BATCH_DELETE_BY_EZ_DELETE_METHOD = "batchDeleteByEzDelete";
    public static final String DELETE_BY_SQL_METHOD = "deleteBySql";

    @MethodName(value="delete")
    public String delete(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Object entity = paramHolder.get("mp_entity");
        EntityClassInfo entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, ntClass);
        Method fieldGetMethod = entityClassInfo.getPrimaryKeyInfo().getFieldGetMethod();
        Object id = ReflectionUtils.invokeMethod(entity, fieldGetMethod, new Object[0]);
        param.put("id", id);
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getDeleteByIdSql(configuration, paramHolder, ntClass, id);
    }

    @MethodName(value="batchDelete")
    public String batchDelete(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Collection entitys = (Collection)paramHolder.get("mp_entitys");
        ArrayList ids = new ArrayList(entitys.size());
        for (Object entity : entitys) {
            EntityClassInfo entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, ntClass);
            Method fieldGetMethod = entityClassInfo.getPrimaryKeyInfo().getFieldGetMethod();
            Object id = ReflectionUtils.invokeMethod(entity, fieldGetMethod, new Object[0]);
            ids.add(id);
        }
        param.put("ids", ids);
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getBatchDeleteByIdSql(configuration, paramHolder, ntClass, ids);
    }

    @MethodName(value="deleteById")
    public String deleteById(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Object id = paramHolder.get("mp_id");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getDeleteByIdSql(configuration, paramHolder, ntClass, id);
    }

    @MethodName(value="batchDeleteById")
    public String batchDeleteById(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Collection ids = (Collection)paramHolder.get("mp_ids");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getBatchDeleteByIdSql(configuration, paramHolder, ntClass, ids);
    }

    @MethodName(value="deleteByEzDelete")
    public String deleteByEzDelete(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        EzDelete delete = (EzDelete)paramHolder.get("mp");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getDeleteSql(configuration, paramHolder, delete);
    }

    @MethodName(value="batchDeleteByEzDelete")
    public String batchDeleteByEzDelete(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Collection deletes = (Collection)paramHolder.get("mp");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getDeleteSql(configuration, paramHolder, deletes);
    }

    @MethodName(value="deleteBySql")
    public String deleteBySql(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        String sql = (String)paramHolder.get("mp_sql");
        Map sqlParam = (Map)paramHolder.get("mp_sql_param");
        param.putAll(sqlParam);
        return sql;
    }
}

