/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.mapper.provider;

import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.annotation.MethodName;
import org.rdlinux.ezmybatis.core.EzUpdate;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlgenerate.SqlGenerateFactory;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;

public class EzUpdateProvider {
    public static final String UPDATE_METHOD = "update";
    public static final String BATCH_UPDATE_METHOD = "batchUpdate";
    public static final String REPLACE_METHOD = "replace";
    public static final String BATCH_REPLACE_METHOD = "batchReplace";
    public static final String UPDATE_BY_EZ_UPDATE_METHOD = "updateByEzUpdate";
    public static final String BATCH_UPDATE_BY_EZ_UPDATE_METHOD = "batchUpdateByEzUpdate";
    public static final String UPDATE_BY_SQL_METHOD = "updateBySql";

    @MethodName(value="update")
    public String update(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Object entity = paramHolder.get("mp_entity");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getUpdateSql(configuration, paramHolder, entity, false);
    }

    @MethodName(value="batchUpdate")
    public String batchUpdate(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Collection entitys = (Collection)paramHolder.get("mp_entitys");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getBatchUpdateSql(configuration, paramHolder, entitys, false);
    }

    @MethodName(value="replace")
    public String replace(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Object entity = paramHolder.get("mp_entity");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getUpdateSql(configuration, paramHolder, entity, true);
    }

    @MethodName(value="batchReplace")
    public String batchReplace(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Collection entitys = (Collection)paramHolder.get("mp_entitys");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getBatchUpdateSql(configuration, paramHolder, entitys, true);
    }

    @MethodName(value="updateByEzUpdate")
    public String updateByEzUpdate(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        EzUpdate update = (EzUpdate)paramHolder.get("mp");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getUpdateSql(configuration, paramHolder, update);
    }

    @MethodName(value="batchUpdateByEzUpdate")
    public String batchUpdateByEzUpdate(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        Configuration configuration = (Configuration)paramHolder.get("mp_configuration");
        Collection updates = (Collection)paramHolder.get("mp");
        return SqlGenerateFactory.getSqlGenerate(DbTypeUtils.getDbType(configuration)).getUpdateSql(configuration, paramHolder, updates);
    }

    @MethodName(value="updateBySql")
    public String updateBySql(Map<String, Object> param) {
        MybatisParamHolder paramHolder = new MybatisParamHolder(param);
        String sql = (String)paramHolder.get("mp_sql");
        Map sqlParam = (Map)paramHolder.get("mp_sql_param");
        param.putAll(sqlParam);
        return sql;
    }
}

