/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlgenerate;

import java.util.HashMap;
import java.util.Map;
import org.rdlinux.ezmybatis.EzMybatisConfig;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;

public class DbKeywordQMFactory {
    private static final Map<DbType, String> DB_TYPE_MAP_KEYWORD_QM = new HashMap<DbType, String>();
    private EzMybatisConfig ezMybatisConfig;
    private volatile String keywordQM;

    public DbKeywordQMFactory(EzMybatisConfig ezMybatisConfig) {
        this.ezMybatisConfig = ezMybatisConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKeywordQM() {
        if (this.keywordQM == null) {
            DbKeywordQMFactory dbKeywordQMFactory = this;
            synchronized (dbKeywordQMFactory) {
                if (this.keywordQM != null) {
                    return this.keywordQM;
                }
                this.keywordQM = this.ezMybatisConfig.isEscapeKeyword() ? DB_TYPE_MAP_KEYWORD_QM.get((Object)DbTypeUtils.getDbType(this.ezMybatisConfig.getConfiguration())) : "";
            }
        }
        return this.keywordQM;
    }

    static {
        DB_TYPE_MAP_KEYWORD_QM.put(DbType.MYSQL, "`");
        DB_TYPE_MAP_KEYWORD_QM.put(DbType.ORACLE, "\"");
        DB_TYPE_MAP_KEYWORD_QM.put(DbType.DM, "\"");
    }
}

