/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzParam;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;

public class From
implements SqlStruct {
    private static final Map<DbType, SqlStruct> CONVERT = new HashMap<DbType, SqlStruct>();
    private Table table;

    public From(Table table) {
        this.table = table;
    }

    private static StringBuilder fromSql(StringBuilder sqlBuilder, Configuration configuration, MybatisParamHolder paramHolder, EzParam<?> param) {
        From from = param.getFrom();
        Table fromTable = from.getTable();
        sqlBuilder.append(" FROM ").append(fromTable.toSqlStruct(configuration, paramHolder));
        return sqlBuilder;
    }

    @Override
    public StringBuilder toSqlPart(StringBuilder sqlBuilder, Configuration configuration, EzParam<?> ezParam, MybatisParamHolder mybatisParamHolder) {
        return CONVERT.get((Object)DbTypeUtils.getDbType(configuration)).toSqlPart(sqlBuilder, configuration, ezParam, mybatisParamHolder);
    }

    public Table getTable() {
        return this.table;
    }

    public From setTable(Table table) {
        this.table = table;
        return this;
    }

    static {
        SqlStruct defaultConvert = (sqlBuilder, configuration, ezParam, mybatisParamHolder) -> From.fromSql(sqlBuilder, configuration, mybatisParamHolder, ezParam);
        CONVERT.put(DbType.MYSQL, defaultConvert);
        CONVERT.put(DbType.ORACLE, defaultConvert);
        CONVERT.put(DbType.DM, defaultConvert);
    }
}

